/*
 * Decompiled with CFR 0.152.
 */
package binnie.core;

import binnie.core.Binnie;
import binnie.core.BinnieCoreMod;
import binnie.core.IBinnieMod;
import binnie.core.Localised;
import binnie.core.block.TileEntityMetadata;
import binnie.core.config.ConfigurationMain;
import binnie.core.config.ConfigurationManager;
import binnie.core.genetics.BeeBreedingSystem;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.MothBreedingSystem;
import binnie.core.genetics.TreeBreedingSystem;
import binnie.core.gui.BinnieGUIHandler;
import binnie.core.language.LocalisedString;
import binnie.core.liquid.ItemFluidContainer;
import binnie.core.liquid.LiquidManager;
import binnie.core.machines.MachineManager;
import binnie.core.network.BinnieCorePacketID;
import binnie.core.network.IPacketID;
import binnie.core.network.packet.PacketNBT;
import binnie.core.plugin.IBinnieModule;
import binnie.core.proxy.BinnieProxy;
import binnie.core.proxy.IBinnieProxy;
import binnie.core.triggers.BinnieAction;
import binnie.core.triggers.BinnieTrigger;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;

@Mod(modid="BinnieCore", name="Binnie Core", version="1.8.0", dependencies="after:Forestry")
@NetworkMod(clientSideRequired=true, serverSideRequired=true)
public class BinnieCore
extends BinnieCoreMod {
    @Mod.Instance(value="BinnieCore")
    public static BinnieCore instance;
    @SidedProxy(clientSide="binnie.core.proxy.BinnieProxyClient", serverSide="binnie.core.proxy.BinnieProxyServer")
    public static BinnieProxy proxy;
    boolean hasLoadedBreedingArrays = false;
    public static List<IBinnieMod> mods;
    public static Item fluidContainer;
    static List<ItemData> itemData;
    static List<BlockData> blockData;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        this.postInit();
    }

    public BinnieCore() {
        ConfigurationManager.init();
    }

    @Override
    public void preInit() {
        instance = this;
        fluidContainer = new ItemFluidContainer(ConfigurationMain.fluidContainerID);
        super.preInit();
    }

    @Override
    public void init() {
        super.init();
        Strings.BranchDiscovered = Binnie.Language.registerGUI(this, "breedingmessage.branch");
        Strings.SpeciesDiscovered = Binnie.Language.registerGUI(this, "breedingmessage.species");
        Strings.EpithetGained = Binnie.Language.registerGUI(this, "breedingmessage.epithet");
        MachineManager.doInit();
        LiquidManager.init();
        Binnie.Genetics.beeBreedingSystem = new BeeBreedingSystem();
        Binnie.Genetics.treeBreedingSystem = new TreeBreedingSystem();
        Binnie.Genetics.mothBreedingSystem = new MothBreedingSystem();
        for (IBinnieMod mod : mods) {
            NetworkRegistry.instance().registerGuiHandler((Object)mod, (IGuiHandler)new BinnieGUIHandler(mod));
        }
        GameRegistry.registerTileEntity(TileEntityMetadata.class, (String)"binnie.tile.metadata");
        BinnieAction.setup();
        BinnieTrigger.setup();
        BinnieCore.checkBlocksAndItems();
    }

    @Override
    public void postInit() {
        super.postInit();
        MachineManager.postInit();
        Binnie.Language.init();
        BinnieCore.checkBlocksAndItems();
    }

    @ForgeSubscribe
    public void onWorldLoad(WorldEvent.Load event) {
        if (this.hasLoadedBreedingArrays) {
            return;
        }
        this.hasLoadedBreedingArrays = true;
        for (BreedingSystem system : BreedingSystem.BREEDING_SYSTEMS.values()) {
            system.calculateArrays();
        }
    }

    public static void registerMod(IBinnieMod mod) {
        mods.add(mod);
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void handleTextureRefresh(TextureStitchEvent.Pre event) {
        proxy.handleTextureRefresh((IconRegister)event.map, event.map.field_94255_a);
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void handlePostTextureRefresh(TextureStitchEvent.Post event) {
        proxy.handlePostTextureRefresh((IconRegister)event.map, event.map.field_94255_a);
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void handleSpeciesDiscovered(ForestryEvent.SpeciesDiscovered event) {
        try {
            EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(event.username);
            if (player == null) {
                return;
            }
            event.tracker.synchToPlayer((EntityPlayer)player);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("species", event.species.getUID());
            this.getProxy().sendToPlayer(this, new PacketNBT(BinnieCorePacketID.Breeding.ordinal(), nbt), (EntityPlayer)player);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getChannel() {
        return "BIN";
    }

    @Override
    public IBinnieProxy getProxy() {
        return proxy;
    }

    @Override
    public String getId() {
        return "binniecore";
    }

    @Override
    public IPacketID[] getPacketIDs() {
        return BinnieCorePacketID.values();
    }

    @Override
    public void addModMetadata(ModMetadata metadata) {
        metadata.description = "Core Mod that handles core networking, gui, tile entity and other implementations required for Extra Bees and other planned Mods.";
    }

    @Override
    public void registerModules(List<IBinnieModule> list) {
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void handleTextureRemap(TextureStitchEvent.Pre event) {
        if (event.map.field_94255_a == 0) {
            LiquidManager.updateTextures((IconRegister)event.map);
        }
    }

    @Override
    public Class[] getConfigs() {
        return new Class[]{ConfigurationMain.class};
    }

    private static void checkBlocksAndItems() {
        for (ItemData itemData : BinnieCore.itemData) {
            itemData.check();
        }
        for (BlockData blockData : BinnieCore.blockData) {
            blockData.check();
        }
    }

    static void loadModBlocksAndItems(IBinnieMod mod) {
        try {
            for (Field field : mod.getClass().getFields()) {
                if (Item.class.isAssignableFrom(field.getType())) {
                    itemData.add(new ItemData(mod, field));
                }
                if (!Block.class.isAssignableFrom(field.getType())) continue;
                blockData.add(new BlockData(mod, field));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        mods = new ArrayList<IBinnieMod>();
        itemData = new ArrayList<ItemData>();
        blockData = new ArrayList<BlockData>();
    }

    public static class Strings {
        @Localised(key="gui.breedingmessage.branch")
        public static LocalisedString BranchDiscovered;
        @Localised(key="gui.breedingmessage.species")
        public static LocalisedString SpeciesDiscovered;
        @Localised(key="gui.breedingmessage.epithet")
        public static LocalisedString EpithetGained;
    }

    static class BlockData
    extends Data<Block> {
        public BlockData(IBinnieMod mod, Field field) {
            super(mod, field);
        }

        @Override
        protected Block getThingInList(Block value) {
            return Block.field_71973_m[value.field_71990_ca];
        }

        @Override
        protected RuntimeException getRuntimeException(Block myThing, Block imposter) {
            return new RuntimeException("Block ID Conflict has occured using ID " + myThing.field_71990_ca + ". The block " + myThing + " has been overwritten by " + imposter);
        }
    }

    static class ItemData
    extends Data<Item> {
        public ItemData(IBinnieMod mod, Field field) {
            super(mod, field);
        }

        @Override
        protected Item getThingInList(Item value) {
            return Item.field_77698_e[value.field_77779_bT];
        }

        @Override
        protected RuntimeException getRuntimeException(Item myThing, Item imposter) {
            return new RuntimeException("Item ID Conflict has occured using ID " + myThing.field_77779_bT + ". The item " + myThing + " has been overwritten by " + imposter);
        }
    }

    static abstract class Data<T> {
        IBinnieMod mod;
        Field field;
        boolean registered = false;

        private Data(IBinnieMod mod, Field field) {
            this.mod = mod;
            this.field = field;
        }

        public void check() {
            RuntimeException exception = null;
            try {
                Object value = this.field.get(null);
                if (this.isRegistered(value) && !this.registered) {
                    this.registered = true;
                }
                if (!this.isRegistered(value) && this.registered && value != null && this.getThingInList(value) != null) {
                    exception = this.getRuntimeException(value, this.getThingInList(value));
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (exception != null) {
                throw exception;
            }
        }

        protected abstract RuntimeException getRuntimeException(T var1, T var2);

        protected boolean isRegistered(T value) {
            return value != null && this.getThingInList(value) == value;
        }

        protected abstract T getThingInList(T var1);
    }
}

