/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.core.inventory.InventoryWrapper;
import mrtjp.projectred.core.inventory.SimpleInventory;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.transportation.ItemRoutingChip;
import mrtjp.projectred.transportation.RoutedPayload;
import mrtjp.projectred.transportation.RoutingChipset;
import mrtjp.projectred.transportation.SyncResponse;
import org.lwjgl.input.Keyboard;

public class RoutingChipset_ItemResponder
extends RoutingChipset {
    public SimpleInventory filter = new SimpleInventory(9, "filter", 1);
    private final RoutedPayload.SendPriority priority = this.getSendPriority();
    public int preference = 0;
    public boolean filterExclude = false;
    public boolean fuzzyMode = false;
    public int fuzzyDamageMode = 0;
    public static final int[] fuzzyPercent = new int[]{0, 25, 50, 75, 100};

    public void prefUp() {
        this.preference = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? (this.preference += 10) : ++this.preference;
        if (this.preference > this.prefScale()) {
            this.preference = this.prefScale();
        }
    }

    public void prefDown() {
        this.preference = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? (this.preference -= 10) : --this.preference;
        if (this.preference < -this.prefScale()) {
            this.preference = -this.prefScale();
        }
    }

    private int prefScale() {
        return 2 + this.getUpgradeBus().LLatency();
    }

    public void shiftFuzzy() {
        this.fuzzyDamageMode = (this.fuzzyDamageMode + 1) % 5;
    }

    @Override
    public SyncResponse getSyncResponse(ItemKey item, SyncResponse rival) {
        InventoryWrapper inv;
        int room;
        InventoryWrapper filt;
        mo real = this.inventoryProvider().getInventory();
        int side = this.inventoryProvider().getInterfacedSide();
        if (real == null || side < 0) {
            return null;
        }
        if ((this.priority.ordinal() > rival.priority.ordinal() || this.priority.ordinal() == rival.priority.ordinal() && this.preference > rival.customPriority) && (filt = InventoryWrapper.wrapInventory((mo)this.filter).setSlotsAll().setFuzzy(this.fuzzyMode).setFuzzyPercent(fuzzyPercent[this.fuzzyDamageMode])).hasItem(item) != this.filterExclude && (room = (inv = InventoryWrapper.wrapInventory((mo)real).setSlotsFromSide(side)).getRoomAvailableForItem(item)) > 0) {
            return new SyncResponse().setPriority(this.priority).setCustomPriority(this.preference).setItemCount(room);
        }
        return null;
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        this.filter.save(tag);
        tag.a("pref", this.preference);
        tag.a("mode", this.filterExclude);
        tag.a("fuz", this.fuzzyMode);
        tag.a("fuzd", (byte)this.fuzzyDamageMode);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.filter.load(tag);
        this.preference = tag.e("pref");
        this.filterExclude = tag.n("mode");
        this.fuzzyMode = tag.n("fuz");
        this.fuzzyDamageMode = tag.c("fuzd");
    }

    @Override
    public List<String> infoCollection() {
        LinkedList<String> list = new LinkedList<String>();
        this.addPriorityInfo(list);
        this.addFilterInfo(list);
        return list;
    }

    public void addPriorityInfo(List<String> list) {
        list.add(a.h + "Preference: " + this.preference);
    }

    public void addFilterInfo(List<String> list) {
        list.add(a.h + "Fuzzy Mode: " + this.fuzzyMode);
        list.add(a.h + "Fuzzy Tool Damage: " + fuzzyPercent[this.fuzzyDamageMode] + "%");
        list.add(a.h + "Filter Mode: " + (this.filterExclude ? "blacklist" : "whitelist"));
        list.add(a.h + "Filter: ");
        boolean added = false;
        for (int i = 0; i < this.filter.j_(); ++i) {
            ye stack = this.filter.a(i);
            if (stack == null) continue;
            list.add(a.h + " - " + stack.s());
            added = true;
        }
        if (!added) {
            list.add(a.h + " - empty");
        }
    }

    protected RoutedPayload.SendPriority getSendPriority() {
        return RoutedPayload.SendPriority.PASSIVE;
    }

    @Override
    public ItemRoutingChip.EnumRoutingChip getChipType() {
        return ItemRoutingChip.EnumRoutingChip.ITEMRESPONDER;
    }

    @Override
    public RoutingChipset.UpgradeBus createUpgradeBus() {
        RoutingChipset.UpgradeBus b = new RoutingChipset.UpgradeBus(3, 0);
        b.setLatency(3, 5, 54, 0, 0, 0);
        b.Linfo = "raise maximum preference value";
        b.Lformula = "preference value = 2 + Latency";
        return b;
    }
}

