/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mrtjp.projectred.core.inventory.InventoryWrapper;
import mrtjp.projectred.core.inventory.SimpleInventory;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.transportation.ItemRoutingChip;
import mrtjp.projectred.transportation.RoutingChipset;
import mrtjp.projectred.transportation.SyncResponse;

public class RoutingChipset_ItemExtractor
extends RoutingChipset {
    public SimpleInventory filter = new SimpleInventory(9, "filter", 1);
    public int extractOrient = -1;
    public boolean filterExclude = false;
    public boolean fuzzyMode = false;
    public int fuzzyDamageMode = 0;
    public static final int[] fuzzyPercent = new int[]{0, 25, 50, 75, 100};
    private int remainingDelay = this.operationDelay();
    public static final String[] dirs = new String[]{"Down", "Up", "North", "South", "West", "East"};

    private int operationDelay() {
        return 100 - this.getUpgradeBus().LLatency();
    }

    private int itemsToExtract() {
        return 8 + this.getUpgradeBus().RLatency();
    }

    public void setOrient(int orient) {
        this.extractOrient = orient;
    }

    public void shiftFuzzy() {
        this.fuzzyDamageMode = (this.fuzzyDamageMode + 1) % 5;
    }

    @Override
    public void update() {
        if (--this.remainingDelay > 0) {
            return;
        }
        this.remainingDelay = this.operationDelay();
        mo real = this.inventoryProvider().getInventory();
        if (real == null) {
            return;
        }
        int side = this.extractOrient == -1 ? this.inventoryProvider().getInterfacedSide() : this.extractOrient;
        InventoryWrapper inv = InventoryWrapper.wrapInventory((mo)real).setSlotsFromSide(side);
        InventoryWrapper filt = InventoryWrapper.wrapInventory((mo)this.filter).setSlotsAll().setFuzzy(this.fuzzyMode).setFuzzyPercent(fuzzyPercent[this.fuzzyDamageMode]);
        Map available = inv.getAllItemStacks();
        for (Map.Entry items : available.entrySet()) {
            ItemKey stackKey = (ItemKey)items.getKey();
            int stackSize = (Integer)items.getValue();
            if (stackKey == null || filt.hasItem(stackKey) == this.filterExclude) continue;
            BitSet exclusions = new BitSet();
            SyncResponse s = this.routeLayer().getLogisticPath(stackKey, exclusions, true);
            if (s == null) continue;
            int leftInRun = this.itemsToExtract();
            while (s != null) {
                int toExtract = Math.min(leftInRun, stackSize);
                toExtract = Math.min(toExtract, stackKey.makeStack(0).e());
                if (s.itemCount > 0) {
                    toExtract = Math.min(toExtract, s.itemCount);
                }
                if (toExtract <= 0) break;
                ye stack2 = stackKey.makeStack(0);
                stack2.b = inv.extractItem(stackKey, toExtract);
                if (stack2.b == 0) break;
                this.routeLayer().queueStackToSend(stack2, this.inventoryProvider().getInterfacedSide(), s);
                if ((leftInRun -= stack2.b) <= 0) break;
                exclusions.set(s.responder);
                s = this.routeLayer().getLogisticPath(stackKey, exclusions, true);
            }
            return;
        }
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        this.filter.save(tag);
        tag.a("mode", this.filterExclude);
        tag.a("orient", this.extractOrient);
        tag.a("fuz", this.fuzzyMode);
        tag.a("fuzd", (byte)this.fuzzyDamageMode);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.filter.load(tag);
        this.filterExclude = tag.n("mode");
        this.extractOrient = tag.e("orient");
        this.fuzzyMode = tag.n("fuz");
        this.fuzzyDamageMode = tag.c("fuzd");
    }

    @Override
    public List<String> infoCollection() {
        LinkedList<String> list = new LinkedList<String>();
        this.addUpgradeBusInfo(list);
        this.addOrientInfo(list);
        this.addFilterInfo(list);
        return list;
    }

    public void addOrientInfo(List<String> list) {
        list.add(a.h + "Extract Orientation: " + (this.extractOrient == -1 ? "Default" : dirs[this.extractOrient]));
    }

    public void addFilterInfo(List<String> list) {
        list.add(a.h + "Fuzzy Mode: " + this.fuzzyMode);
        list.add(a.h + "Fuzzy Tool Damage: " + fuzzyPercent[this.fuzzyDamageMode] + "%");
        list.add(a.h + "Filter Mode: " + (this.filterExclude ? "exclude" : "include"));
        list.add(a.h + "Filter: ");
        boolean added = false;
        for (int i = 0; i < this.filter.j_(); ++i) {
            ye stack = this.filter.a(i);
            if (stack == null) continue;
            list.add(a.h + " - " + stack.s());
            added = true;
        }
        if (!added) {
            list.add(a.h + " - empty");
        }
    }

    @Override
    public ItemRoutingChip.EnumRoutingChip getChipType() {
        return ItemRoutingChip.EnumRoutingChip.ITEMEXTRACTOR;
    }

    @Override
    public RoutingChipset.UpgradeBus createUpgradeBus() {
        RoutingChipset.UpgradeBus b = new RoutingChipset.UpgradeBus(3, 3);
        b.setLatency(25, 34, 40, 8, 16, 32);
        b.Linfo = "delay between extractions";
        b.Lformula = "delay = 100 - Latency";
        b.Rinfo = "items to extract in one operation";
        b.Rformula = "items = 8 + Latency";
        return b;
    }
}

