/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mrtjp.projectred.core.inventory.InventoryWrapper;
import mrtjp.projectred.core.inventory.SimpleInventory;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.core.utils.Pair2;
import mrtjp.projectred.transportation.DeliveryManager;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.ItemRoutingChip;
import mrtjp.projectred.transportation.RequestBranchNode;
import mrtjp.projectred.transportation.RoutedPayload;
import mrtjp.projectred.transportation.RoutingChipset;
import org.lwjgl.input.Keyboard;

public class RoutingChipset_ItemBroadcaster
extends RoutingChipset {
    public SimpleInventory filter = new SimpleInventory(9, "filter", 1);
    public int extractOrient = -1;
    public boolean filterExclude = true;
    public int preference = 0;
    int hideMode = 0;
    int timeRemaining = this.operationDelay();
    private final DeliveryManager manager = new DeliveryManager();
    public static final String[] dirs = new String[]{"Down", "Up", "North", "South", "West", "East"};
    public static final String[] hide = new String[]{"off", "one per type", "one per stack"};

    public void prefUp() {
        this.preference = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? (this.preference += 10) : ++this.preference;
        if (this.preference > 100) {
            this.preference = 100;
        }
    }

    public void prefDown() {
        this.preference = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? (this.preference -= 10) : --this.preference;
        if (this.preference < -100) {
            this.preference = -100;
        }
    }

    public void shiftOrient() {
        ++this.extractOrient;
        if (this.extractOrient > 5) {
            this.extractOrient = -1;
        }
    }

    public void shiftHiding() {
        this.hideMode = (this.hideMode + 1) % 3;
    }

    private int stacksToExtract() {
        return 1 + this.getUpgradeBus().LLatency();
    }

    private int itemsToExtract() {
        return 8 + this.getUpgradeBus().RLatency();
    }

    private int operationDelay() {
        return 5;
    }

    @Override
    public void update() {
        if (--this.timeRemaining > 0) {
            return;
        }
        this.timeRemaining = this.operationDelay();
        if (!this.manager.hasOrders()) {
            return;
        }
        Pair2<ItemKeyStack, IWorldRequester> next = null;
        int stacksRemaining = this.stacksToExtract();
        int itemsRemaining = this.itemsToExtract();
        while (this.manager.hasOrders() && (next = this.manager.peek()) != null && stacksRemaining > 0 && itemsRemaining > 0) {
            int removed;
            mo real = this.inventoryProvider().getInventory();
            if (real == null) {
                this.manager.dispatchFailed();
                continue;
            }
            ItemKeyStack reqKeyStack = (ItemKeyStack)next.getValue1();
            IWorldRequester requester = (IWorldRequester)next.getValue2();
            int side = this.extractOrient == -1 ? this.inventoryProvider().getInterfacedSide() : this.extractOrient;
            InventoryWrapper inv = InventoryWrapper.wrapInventory((mo)real).setSlotsFromSide(side);
            if (this.hideMode == 1) {
                inv.setHidePerType(true);
            } else if (this.hideMode == 2) {
                inv.setHidePerSlot(true);
            }
            if (!this.routeLayer().getRouter().canRouteTo(requester.getRouter().getIPAddress())) {
                this.manager.dispatchFailed();
                continue;
            }
            int toExtract = Math.min(inv.getItemCount(reqKeyStack.key()), reqKeyStack.stackSize);
            toExtract = Math.min(toExtract, itemsRemaining);
            toExtract = Math.min(toExtract, reqKeyStack.makeStack().e());
            boolean reStock = false;
            int destinationSpace = requester.getActiveFreeSpace(reqKeyStack.key());
            if (destinationSpace < toExtract) {
                toExtract = destinationSpace;
                if (toExtract <= 0) {
                    this.manager.reStock();
                    break;
                }
                reStock = true;
            }
            if ((removed = inv.extractItem(reqKeyStack.key(), toExtract)) <= 0) {
                this.manager.dispatchFailed();
                continue;
            }
            ye toSend = reqKeyStack.key().makeStack(removed);
            this.routeLayer().queueStackToSend(toSend, this.inventoryProvider().getInterfacedSide(), RoutedPayload.SendPriority.ACTIVE, requester.getRouter().getIPAddress());
            this.manager.dispatchSuccessful(removed, reStock);
            --stacksRemaining;
            itemsRemaining -= removed;
        }
    }

    @Override
    public void requestPromises(RequestBranchNode request, int existingPromises) {
        ItemKey requested;
        mo real = this.inventoryProvider().getInventory();
        if (real == null) {
            return;
        }
        int side = this.extractOrient == -1 ? this.inventoryProvider().getInterfacedSide() : this.extractOrient;
        InventoryWrapper inv = InventoryWrapper.wrapInventory((mo)real).setSlotsFromSide(side);
        InventoryWrapper filt = InventoryWrapper.wrapInventory((mo)this.filter).setSlotsAll();
        if (filt.hasItem(requested = request.getRequestedPackage()) != this.filterExclude) {
            if (this.hideMode == 1) {
                inv.setHidePerType(true);
            } else if (this.hideMode == 2) {
                inv.setHidePerSlot(true);
            }
            int numberAvailable = inv.getItemCount(requested);
            if ((numberAvailable -= existingPromises) > 0) {
                RequestBranchNode.DeliveryPromise promise = new RequestBranchNode.DeliveryPromise();
                promise.setPackage(requested).setSize(Math.min(request.getMissingCount(), numberAvailable)).setSender(this.routeLayer().getBroadcaster());
                request.addPromise(promise);
            }
        }
    }

    @Override
    public void deliverPromises(RequestBranchNode.DeliveryPromise promise, IWorldRequester requester) {
        this.manager.addOrder(ItemKeyStack.get((ItemKey)promise.thePackage, (int)promise.size), requester);
    }

    @Override
    public void getProvidedItems(Map<ItemKey, Integer> map) {
        mo real = this.inventoryProvider().getInventory();
        if (real == null) {
            return;
        }
        int side = this.extractOrient == -1 ? this.inventoryProvider().getInterfacedSide() : this.extractOrient;
        InventoryWrapper inv = InventoryWrapper.wrapInventory((mo)real).setSlotsFromSide(side);
        InventoryWrapper filt = InventoryWrapper.wrapInventory((mo)this.filter).setSlotsAll();
        if (this.hideMode == 1) {
            inv.setHidePerType(true);
        } else if (this.hideMode == 2) {
            inv.setHidePerSlot(true);
        }
        Map items = inv.getAllItemStacks();
        for (Map.Entry entry : items.entrySet()) {
            if (filt.hasItem((ItemKey)entry.getKey()) == this.filterExclude) continue;
            Integer current = map.get(entry.getKey());
            int toAdd = (Integer)entry.getValue() - this.manager.getDeliveryCount((ItemKey)entry.getKey());
            if (toAdd <= 0) continue;
            if (current == null) {
                map.put((ItemKey)entry.getKey(), toAdd);
                continue;
            }
            map.put((ItemKey)entry.getKey(), current + toAdd);
        }
    }

    @Override
    public int getPriority() {
        return this.preference;
    }

    @Override
    public void onPipeBroken() {
        while (this.manager.hasOrders()) {
            this.manager.dispatchFailed();
        }
    }

    @Override
    public void save(by tag) {
        super.save(tag);
        this.filter.save(tag);
        tag.a("mode", this.filterExclude);
        tag.a("pref", this.preference);
        tag.a("orient", this.extractOrient);
        tag.a("hide", (byte)this.hideMode);
    }

    @Override
    public void load(by tag) {
        super.load(tag);
        this.filter.load(tag);
        this.filterExclude = tag.n("mode");
        this.preference = tag.e("pref");
        this.extractOrient = tag.e("orient");
        this.hideMode = tag.c("hide");
    }

    @Override
    public List<String> infoCollection() {
        LinkedList<String> list = new LinkedList<String>();
        this.addPriorityInfo(list);
        this.addOrientInfo(list);
        this.addFilterInfo(list);
        return list;
    }

    public void addFilterInfo(List<String> list) {
        list.add(a.h + "Hide Mode: " + hide[this.hideMode]);
        list.add(a.h + "Filter Mode: " + (this.filterExclude ? "blacklist" : "whitelist"));
        list.add(a.h + "Filter: ");
        boolean added = false;
        for (int i = 0; i < this.filter.j_(); ++i) {
            ye stack = this.filter.a(i);
            if (stack == null) continue;
            list.add(a.h + " - " + stack.s());
            added = true;
        }
        if (!added) {
            list.add(a.h + " - empty");
        }
    }

    public void addPriorityInfo(List<String> list) {
        list.add(a.h + "Preference: " + this.preference);
    }

    public void addOrientInfo(List<String> list) {
        list.add(a.h + "Extract Orientation: " + (this.extractOrient == -1 ? "Default" : dirs[this.extractOrient]));
    }

    @Override
    public ItemRoutingChip.EnumRoutingChip getChipType() {
        return ItemRoutingChip.EnumRoutingChip.ITEMBROADCASTER;
    }

    @Override
    public RoutingChipset.UpgradeBus createUpgradeBus() {
        RoutingChipset.UpgradeBus b = new RoutingChipset.UpgradeBus(3, 3);
        b.setLatency(1, 2, 4, 8, 16, 32);
        b.Linfo = "stacks to check in one operation";
        b.Lformula = "stacks = 1 + Latency";
        b.Rinfo = "items to extract in one operation";
        b.Rformula = "items = 8 + Latency";
        return b;
    }
}

