/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TMultiPart;
import java.util.Random;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.PRColors;
import mrtjp.projectred.core.fx.CoreParticle;
import mrtjp.projectred.core.fx.ParticleLogic;
import mrtjp.projectred.core.fx.ParticleLogicApproachPoint;
import mrtjp.projectred.core.fx.ParticleLogicIconShift;
import mrtjp.projectred.core.fx.ParticleLogicOrbitPoint;
import mrtjp.projectred.core.fx.ParticleLogicScale;
import mrtjp.projectred.core.fx.ParticleLogicTrail;
import mrtjp.projectred.core.fx.ParticleManagement;
import mrtjp.projectred.transportation.BasicPipePart;
import mrtjp.projectred.transportation.RoutedJunctionPipePart;
import mrtjp.projectred.transportation.TransportationSPH;

public class RouteFX {
    private static final Random rand = new Random();
    public static final int color_receive = PRColors.ORANGE.ordinal();
    public static final int color_send = PRColors.PURPLE.ordinal();
    public static final int color_relay = PRColors.CYAN.ordinal();
    public static final int color_routeLost = PRColors.MAGENTA.ordinal();
    public static final int color_route = PRColors.RED.ordinal();
    public static final int color_sync = PRColors.LIGHT_BLUE.ordinal();
    public static final int color_request = PRColors.PINK.ordinal();
    public static final int color_checkInv = PRColors.WHITE.ordinal();
    public static final int color_linked = PRColors.LIME.ordinal();
    public static final int color_unlinked = PRColors.RED.ordinal();
    public static final int color_blink = PRColors.LIGHT_GREY.ordinal();

    public static void spawnType1(int color, int count, BlockCoord bc, abw world) {
        if (!world.I) {
            RouteFX.packetType1(color, count, bc, world);
            return;
        }
        PRColors c = PRColors.get((int)color);
        for (int i = 0; i < count; ++i) {
            RouteFX.doSpawnType1(c, bc, world);
        }
    }

    public static void spawnType2(int color, int count, int dir, BlockCoord bc, abw world) {
        if (!world.I) {
            RouteFX.packetType2(color, count, dir, bc, world);
            return;
        }
        PRColors c = PRColors.get((int)color);
        for (int i = 0; i < count; ++i) {
            RouteFX.doSpawnType2(c, dir, bc, world);
        }
    }

    public static void spawnType3(int color, int count, int dir, BlockCoord bc, abw world) {
        if (!world.I) {
            RouteFX.packetType3(color, count, dir, bc, world);
            return;
        }
        PRColors c = PRColors.get((int)color);
        for (int i = 0; i < count; ++i) {
            RouteFX.doSpawnType3(c, dir, bc, world);
        }
    }

    private static void doSpawnType3(final PRColors color, int dir, BlockCoord bc, abw world) {
        double x = (double)bc.x + 0.5;
        double y = (double)bc.y + 0.5;
        double z = (double)bc.z + 0.5;
        CoreParticle c = ParticleManagement.instance.spawn(world, "box", x, y, z);
        if (c != null) {
            ParticleLogicTrail.IParticleBuilder build = new ParticleLogicTrail.IParticleBuilder(){

                public void build(CoreParticle c2) {
                    ParticleLogicIconShift iconshift = ParticleLogicIconShift.fluttering();
                    ParticleLogicScale scale = new ParticleLogicScale();
                    scale.setRate(-0.001f, -0.001f * rand.nextFloat());
                    scale.setTerminate(true);
                    c2.setIgnoreMaxAge(true);
                    c2.setScale(0.05f + 0.02f * rand.nextFloat());
                    c2.setPRColor(color);
                    c2.addLogic((ParticleLogic)iconshift).addLogic((ParticleLogic)scale);
                }
            };
            ParticleLogicTrail trail = new ParticleLogicTrail("box", build);
            double speed = ls.a((Random)rand, (double)0.1, (double)0.2);
            ParticleLogicPipeRouterFlow flow = new ParticleLogicPipeRouterFlow(bc, dir, color.ordinal(), speed, 0.1);
            flow.setTerminate(true);
            ParticleLogicScale scale = new ParticleLogicScale();
            scale.setRate(-1.0E-4f, 0.0f);
            scale.setTerminate(true);
            c.Z = true;
            c.setIgnoreMaxAge(true);
            c.setScale(0.05f + 0.075f * rand.nextFloat());
            c.setPRColor(color);
            c.addLogic((ParticleLogic)trail).addLogic((ParticleLogic)flow).addLogic((ParticleLogic)scale);
        }
    }

    private static void doSpawnType2(final PRColors color, int dir, BlockCoord bc, abw world) {
        double x = (double)bc.x + 0.5;
        double y = (double)bc.y + 0.5;
        double z = (double)bc.z + 0.5;
        double x1 = (double)bc.x + 0.5 + ls.a((Random)rand, (double)-0.0625, (double)0.0625);
        double y1 = (double)bc.y + 0.5 + ls.a((Random)rand, (double)-0.0625, (double)0.0625);
        double z1 = (double)bc.z + 0.5 + ls.a((Random)rand, (double)-0.0625, (double)0.0625);
        double shift = ls.a((Random)rand, (double)0.8, (double)1.0);
        switch (dir) {
            case 0: {
                y1 = (double)bc.y + 0.5 - shift;
                break;
            }
            case 1: {
                y1 = (double)bc.y + 0.5 + shift;
                break;
            }
            case 2: {
                z1 = (double)bc.z + 0.5 - shift;
                break;
            }
            case 3: {
                z1 = (double)bc.z + 0.5 + shift;
                break;
            }
            case 4: {
                x1 = (double)bc.x + 0.5 - shift;
                break;
            }
            case 5: {
                x1 = (double)bc.x + 0.5 + shift;
            }
        }
        CoreParticle c = ParticleManagement.instance.spawn(world, "box", x, y, z);
        if (c != null) {
            ParticleLogicTrail.IParticleBuilder build = new ParticleLogicTrail.IParticleBuilder(){

                public void build(CoreParticle c2) {
                    ParticleLogicIconShift iconshift = ParticleLogicIconShift.fluttering();
                    ParticleLogicScale scale = new ParticleLogicScale();
                    scale.setRate(-0.001f, -0.001f * rand.nextFloat());
                    scale.setTerminate(true);
                    c2.setIgnoreMaxAge(true);
                    c2.setScale(0.05f + 0.02f * rand.nextFloat());
                    c2.setPRColor(color);
                    c2.addLogic((ParticleLogic)iconshift).addLogic((ParticleLogic)scale);
                }
            };
            ParticleLogicTrail trail = new ParticleLogicTrail("box", build);
            double speed = ls.a((Random)rand, (double)0.1, (double)0.2);
            ParticleLogicApproachPoint approach = new ParticleLogicApproachPoint(new Vector3(x1, y1, z1), speed, 0.1);
            approach.setTerminate(true);
            ParticleLogicScale scale = new ParticleLogicScale();
            scale.setRate(-1.0E-4f, -1.0E-4f);
            scale.setTerminate(true);
            c.Z = true;
            c.setIgnoreMaxAge(true);
            c.setScale(0.05f + 0.075f * rand.nextFloat());
            c.setPRColor(color);
            c.addLogic((ParticleLogic)trail).addLogic((ParticleLogic)scale).addLogic((ParticleLogic)approach);
        }
    }

    private static void doSpawnType1(PRColors color, BlockCoord bc, abw world) {
        double x = (double)bc.x + 0.5 + ls.a((Random)rand, (double)-0.25, (double)0.25);
        double y = (double)bc.y + 0.5 + ls.a((Random)rand, (double)-0.125, (double)0.125);
        double z = (double)bc.z + 0.5 + ls.a((Random)rand, (double)-0.25, (double)0.25);
        double x1 = (double)bc.x + 0.5;
        double y1 = (double)bc.y + 0.5 + 1.0;
        double z1 = (double)bc.z + 0.5;
        CoreParticle c = ParticleManagement.instance.spawn(world, "flutter1", x, y, z);
        if (c != null) {
            ParticleLogicOrbitPoint orbit = new ParticleLogicOrbitPoint(new Vector3(x1, y1, z1));
            orbit.setOrbitSpeed(0.5 * rand.nextDouble()).setTargetDistance(0.3);
            orbit.setShrinkingOrbit(0.01, 0.01);
            ParticleLogicScale scale = new ParticleLogicScale();
            scale.setRate(-0.001f, -1.0E-4f * rand.nextFloat());
            scale.setTerminate(true);
            ParticleLogicIconShift iconshift = ParticleLogicIconShift.fluttering();
            c.setIgnoreMaxAge(true);
            c.setScale(0.05f + 0.02f * rand.nextFloat());
            c.setPRColor(color);
            c.addLogic((ParticleLogic)orbit);
            c.addLogic((ParticleLogic)scale);
            c.addLogic((ParticleLogic)iconshift);
        }
    }

    public static void handleClientPacket(MCDataInput in, abw world) {
        int type = in.readUByte();
        int color = in.readUByte();
        int count = in.readUByte();
        int dir = type != 1 ? in.readUByte() : -1;
        BlockCoord bc = in.readCoord();
        if (type == 1) {
            RouteFX.spawnType1(color, count, bc, world);
        } else if (type == 2) {
            RouteFX.spawnType2(color, count, dir, bc, world);
        } else if (type == 3) {
            RouteFX.spawnType3(color, count, dir, bc, world);
        }
    }

    private static void packetType1(int color, int count, BlockCoord bc, abw world) {
        if (world.I) {
            return;
        }
        PacketCustom packet = new PacketCustom(TransportationSPH.channel, 11);
        packet.writeByte(1);
        packet.writeByte(color).writeByte(count).writeCoord(bc);
        packet.sendPacketToAllAround((double)bc.x, (double)bc.y, (double)bc.z, 64.0, world.t.i);
    }

    private static void packetType2(int color, int count, int dir, BlockCoord bc, abw world) {
        if (world.I) {
            return;
        }
        PacketCustom packet = new PacketCustom(TransportationSPH.channel, 11);
        packet.writeByte(2);
        packet.writeByte(color).writeByte(count).writeCoord(bc).writeByte(dir);
        packet.sendPacketToAllAround((double)bc.x, (double)bc.y, (double)bc.z, 64.0, world.t.i);
    }

    private static void packetType3(int color, int count, int dir, BlockCoord bc, abw world) {
        if (world.I) {
            return;
        }
        PacketCustom packet = new PacketCustom(TransportationSPH.channel, 11);
        packet.writeByte(3);
        packet.writeByte(color).writeByte(count).writeCoord(bc).writeByte(dir);
        packet.sendPacketToAllAround((double)bc.x, (double)bc.y, (double)bc.z, 64.0, world.t.i);
    }

    private static class ParticleLogicPipeRouterFlow
    extends ParticleLogicApproachPoint {
        private int dir;
        private final BlockCoord start;
        private final int color;
        private double deviation = 0.0625;

        public ParticleLogicPipeRouterFlow(BlockCoord start, int dir, int color, double approachSpeed, double targetDistance) {
            super(Vector3.zero, approachSpeed, targetDistance);
            this.dir = dir;
            this.start = start;
            this.color = color;
            this.setTarget(this.generateNextPoint(start));
        }

        private Vector3 generateNextPoint(BlockCoord bc) {
            if (bc == null) {
                bc = this.particle.blockPosition();
            }
            double x1 = (double)bc.x + 0.5 + ls.a((Random)this.rand, (double)(-this.deviation), (double)this.deviation);
            double y1 = (double)bc.y + 0.5 + ls.a((Random)this.rand, (double)(-this.deviation), (double)this.deviation);
            double z1 = (double)bc.z + 0.5 + ls.a((Random)this.rand, (double)(-this.deviation), (double)this.deviation);
            double shift = ls.a((Random)this.rand, (double)(1.0 - this.deviation), (double)(1.0 + this.deviation));
            switch (this.dir) {
                case 0: {
                    y1 = (double)bc.y + 0.5 - shift;
                    break;
                }
                case 1: {
                    y1 = (double)bc.y + 0.5 + shift;
                    break;
                }
                case 2: {
                    z1 = (double)bc.z + 0.5 - shift;
                    break;
                }
                case 3: {
                    z1 = (double)bc.z + 0.5 + shift;
                    break;
                }
                case 4: {
                    x1 = (double)bc.x + 0.5 - shift;
                    break;
                }
                case 5: {
                    x1 = (double)bc.x + 0.5 + shift;
                }
            }
            return new Vector3(x1, y1, z1);
        }

        private void setTarget(Vector3 target) {
            this.targetX = target.x;
            this.targetY = target.y;
            this.targetZ = target.z;
        }

        public void onDestinationReached() {
            BlockCoord bc = this.particle.blockPosition();
            TMultiPart part = BasicUtils.getMultiPart((acf)this.particle.q, (BlockCoord)bc, (int)6);
            if (part instanceof BasicPipePart && !(part instanceof RoutedJunctionPipePart)) {
                BasicPipePart pipe = (BasicPipePart)part;
                int connMap = pipe.connMap;
                if (Integer.bitCount(connMap &= ~(1 << (this.dir ^ 1))) == 1) {
                    int pos;
                    for (pos = 0; (connMap & 1 << pos) == 0 && pos < 6; ++pos) {
                    }
                    this.dir = pos;
                    this.setTarget(this.generateNextPoint(bc));
                    return;
                }
                for (int i = 0; i < 6; ++i) {
                    if ((connMap & 1 << i) == 0) continue;
                    RouteFX.spawnType2(this.color, 1, i, bc, this.particle.q);
                }
                this.finishLogic();
                return;
            }
            this.finishLogic();
        }

        public ParticleLogic clone() {
            ParticleLogicPipeRouterFlow logic = new ParticleLogicPipeRouterFlow(this.start, this.dir, this.color, this.approachSpeed, this.targetDistance);
            logic.setTarget(new Vector3(this.targetX, this.targetY, this.targetZ));
            return logic;
        }
    }
}

