/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.RequestBranch;

public class RequestConsole {
    private EnumSet<RequestBranch.RequestFlags> settings = EnumSet.noneOf(RequestBranch.RequestFlags.class);
    private IWorldRequester destination = null;
    private RequestBranch branch = null;
    private int requested = 0;
    private Map<ItemKey, Integer> used = null;
    private Map<ItemKey, Integer> missing = null;
    private boolean parityBuilt = false;

    public RequestConsole setPulling(boolean flag) {
        if (flag) {
            this.settings.add(RequestBranch.RequestFlags.PULL);
        } else {
            this.settings.remove((Object)RequestBranch.RequestFlags.PULL);
        }
        return this;
    }

    public RequestConsole setCrafting(boolean flag) {
        if (flag) {
            this.settings.add(RequestBranch.RequestFlags.CRAFT);
        } else {
            this.settings.remove((Object)RequestBranch.RequestFlags.CRAFT);
        }
        return this;
    }

    public RequestConsole setPartials(boolean flag) {
        if (flag) {
            this.settings.add(RequestBranch.RequestFlags.PARTIALS);
        } else {
            this.settings.remove((Object)RequestBranch.RequestFlags.PARTIALS);
        }
        return this;
    }

    public RequestConsole setSimulate(boolean flag) {
        if (flag) {
            this.settings.add(RequestBranch.RequestFlags.SIMULATE);
        } else {
            this.settings.remove((Object)RequestBranch.RequestFlags.SIMULATE);
        }
        return this;
    }

    public RequestConsole setDestination(IWorldRequester destination) {
        this.destination = destination;
        return this;
    }

    public int requested() {
        return this.requested;
    }

    public RequestConsole makeRequest(ye request) {
        return this.makeRequest(ItemKeyStack.get((ye)request));
    }

    public RequestConsole makeRequest(ItemKeyStack request) {
        if (this.destination == null) {
            return this;
        }
        this.parityBuilt = false;
        this.used = null;
        this.missing = null;
        this.requested = 0;
        this.branch = new RequestBranch(request.copy(), this.destination, this.settings);
        if (this.branch.isDone() || this.settings.contains((Object)RequestBranch.RequestFlags.PARTIALS) && this.branch.getPromisedCount() > 0) {
            this.requested = this.branch.getPromisedCount();
            if (!this.settings.contains((Object)RequestBranch.RequestFlags.SIMULATE)) {
                this.branch.recurse_RequestDelivery();
            }
        }
        return this;
    }

    private void rebuildParity() {
        if (!this.parityBuilt) {
            this.branch.recurse_RebuildParityTree();
        }
        this.parityBuilt = true;
    }

    private void gatherUsed() {
        if (this.used == null) {
            this.rebuildParity();
            this.used = new HashMap<ItemKey, Integer>();
            this.branch.recurse_GatherStatisticsUsed(this.used);
        }
    }

    private void gatherMissing() {
        if (this.missing == null) {
            this.rebuildParity();
            this.missing = new HashMap<ItemKey, Integer>();
            this.branch.recurse_GatherStatisticsMissing(this.missing);
        }
    }

    public Map<ItemKey, Integer> getUsed() {
        if (this.used == null) {
            this.gatherUsed();
        }
        return this.used;
    }

    public Map<ItemKey, Integer> getMissing() {
        if (this.missing == null) {
            this.gatherMissing();
        }
        return this.missing;
    }
}

