/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import mrtjp.projectred.transportation.BasicPipePart;
import mrtjp.projectred.transportation.RoutedPayload;

public abstract class PipeLogic {
    BasicPipePart p;

    public static PipeLogic createPipeLogic(BasicPipePart p, int meta) {
        if (meta == 0) {
            return new NullPipeLogic(p);
        }
        return new NullPipeLogic(p);
    }

    public PipeLogic(BasicPipePart p) {
        this.p = p;
    }

    public void save(by tag) {
    }

    public void load(by tag) {
    }

    public void readDesc(MCDataInput packet) {
    }

    public void writeDesc(MCDataOutput packet) {
    }

    public void read(MCDataInput packet, int switch_key) {
    }

    public void tick() {
    }

    public abstract boolean endReached(RoutedPayload var1);

    public abstract boolean centerReached(RoutedPayload var1);

    public abstract boolean handleDrop(RoutedPayload var1);

    public abstract boolean resolveDestination(RoutedPayload var1);

    public abstract ms getIcon(BasicPipePart var1, int var2);

    public static class NullPipeLogic
    extends PipeLogic {
        public NullPipeLogic(BasicPipePart p) {
            super(p);
        }

        @Override
        public boolean endReached(RoutedPayload r) {
            return false;
        }

        @Override
        public boolean centerReached(RoutedPayload r) {
            return false;
        }

        @Override
        public boolean resolveDestination(RoutedPayload r) {
            return false;
        }

        @Override
        public ms getIcon(BasicPipePart p, int i) {
            return null;
        }

        @Override
        public boolean handleDrop(RoutedPayload r) {
            return false;
        }
    }
}

