/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import java.util.BitSet;
import java.util.List;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.transportation.BasicPipePart;
import mrtjp.projectred.transportation.IWorldRouter;
import mrtjp.projectred.transportation.Router;
import mrtjp.projectred.transportation.SyncResponse;

public class LogisticPathFinder {
    private final Router source;
    private SyncResponse result;
    private BitSet exclusions = new BitSet();
    private BitSet visited;
    private boolean excludeSource;
    private ItemKey payload;

    public LogisticPathFinder(Router source, ItemKey payload) {
        this.source = source;
        this.payload = payload;
        this.visited = new BitSet(Router.getEndOfIPPool());
    }

    public LogisticPathFinder setExclusions(BitSet exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public LogisticPathFinder setExcludeSource(boolean excludeSource) {
        this.excludeSource = excludeSource;
        return this;
    }

    public SyncResponse getResult() {
        return this.result;
    }

    public LogisticPathFinder findBestResult() {
        SyncResponse bestResponse = new SyncResponse();
        int bestIP = -1;
        for (Router.StartEndPath l : this.source.getRoutesByCost()) {
            SyncResponse sync;
            Router r = l.end;
            if (this.excludeSource && r.getIPAddress() == this.source.getIPAddress() || this.excludeSource && LogisticPathFinder.sharesInventory(this.source.getParent().getContainer(), r.getParent().getContainer()) || this.exclusions.get(r.getIPAddress()) || this.visited.get(r.getIPAddress())) continue;
            this.visited.set(r.getIPAddress());
            IWorldRouter parent = r.getParent();
            if (parent == null || (sync = parent.getSyncResponse(this.payload, bestResponse)) == null) continue;
            if (sync.priority.ordinal() > bestResponse.priority.ordinal()) {
                bestResponse = sync;
                bestIP = r.getIPAddress();
                continue;
            }
            if (sync.priority.ordinal() != bestResponse.priority.ordinal() || sync.customPriority <= bestResponse.customPriority) continue;
            bestResponse = sync;
            bestIP = r.getIPAddress();
        }
        if (bestIP > -1) {
            this.result = bestResponse.setResponder(bestIP);
        }
        return this;
    }

    public static boolean sharesInventory(BasicPipePart pipe1, BasicPipePart pipe2) {
        if (pipe1 == null || pipe2 == null) {
            return false;
        }
        if (pipe1.tile().k != pipe2.tile().k) {
            return false;
        }
        List<mo> adjacent1 = pipe1.getConnectedInventories();
        List<mo> adjacent2 = pipe2.getConnectedInventories();
        for (mo inv1 : adjacent1) {
            if (!adjacent2.contains(inv1)) continue;
            return true;
        }
        return false;
    }
}

