/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mrtjp.projectred.api.ISpecialLinkState;
import mrtjp.projectred.core.utils.Pair2;
import mrtjp.projectred.transportation.BasicPipePart;
import mrtjp.projectred.transportation.IWorldRouter;
import mrtjp.projectred.transportation.Router;
import net.minecraftforge.common.ForgeDirection;

public class LSPathFinder {
    private HashMap<Router, Router.StartEndPath> result;
    private int pipesVisited;
    private final int maxVisited;
    private final int maxLength;
    private final HashSet<BasicPipePart> setVisited = new HashSet();
    private final Router LSAddresser;
    private static final List<ISpecialLinkState> registeredLSTypes = new ArrayList<ISpecialLinkState>();

    public LSPathFinder(IWorldRouter start, int maxVisited, int maxLength) {
        this(start, maxVisited, maxLength, ForgeDirection.UNKNOWN);
    }

    public LSPathFinder(IWorldRouter start, int maxVisited, int maxLength, ForgeDirection side) {
        this.maxVisited = maxVisited;
        this.maxLength = maxLength;
        this.LSAddresser = start.getRouter();
        this.result = this.getConnectedRoutingPipes(start.getContainer(), side);
    }

    private HashMap<Router, Router.StartEndPath> getConnectedRoutingPipes(BasicPipePart start, ForgeDirection side) {
        HashMap<Router, Router.StartEndPath> foundPipes = new HashMap<Router, Router.StartEndPath>();
        boolean root = this.setVisited.isEmpty();
        if (this.setVisited.size() == 1) {
            this.pipesVisited = 0;
        }
        if (this.setVisited.size() > this.maxLength) {
            return foundPipes;
        }
        if (!start.initialized) {
            return foundPipes;
        }
        if (start instanceof IWorldRouter && !root) {
            Router r = ((IWorldRouter)((Object)start)).getRouter();
            if (!r.isLoaded()) {
                return foundPipes;
            }
            foundPipes.put(r, new Router.StartEndPath(this.LSAddresser, r, side.getOpposite().ordinal(), this.setVisited.size()));
            return foundPipes;
        }
        this.setVisited.add(start);
        ArrayDeque<Pair2> connections = new ArrayDeque<Pair2>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (root && side != ForgeDirection.UNKNOWN && !dir.equals((Object)side) || !start.maskConnects(dir.ordinal())) continue;
            BlockCoord bc = new BlockCoord((asp)start.tile()).offset(dir.ordinal());
            asp tile = start.world().r(bc.x, bc.y, bc.z);
            connections.add(new Pair2((Object)tile, (Object)dir));
        }
        while (!connections.isEmpty()) {
            List<asp> connected;
            Pair2 pair = (Pair2)connections.pollFirst();
            asp tile = (asp)pair.getValue1();
            ForgeDirection dir = (ForgeDirection)pair.getValue2();
            if (root && (connected = LSPathFinder.getConnections(tile)) != null && !connected.isEmpty()) {
                for (asp tile2 : connected) {
                    connections.add(new Pair2((Object)tile2, (Object)dir));
                }
                continue;
            }
            if (!(tile instanceof TileMultipart)) continue;
            TileMultipart tile2 = (TileMultipart)tile;
            TMultiPart part = tile2.partMap(6);
            BasicPipePart p = null;
            if (part instanceof BasicPipePart) {
                p = (BasicPipePart)part;
            }
            if (p == null || this.setVisited.contains(p)) continue;
            HashMap<Router, Router.StartEndPath> result = this.getConnectedRoutingPipes(p, dir);
            for (Map.Entry<Router, Router.StartEndPath> entry : result.entrySet()) {
                entry.getValue().dirToFirstHop = dir.ordinal();
                int current = entry.getValue().distance;
                Router.StartEndPath found = foundPipes.get(entry.getKey());
                int previous = found == null ? Integer.MAX_VALUE : found.distance;
                if (current >= previous) continue;
                foundPipes.put(entry.getKey(), entry.getValue());
            }
        }
        this.setVisited.remove(start);
        if (start instanceof IWorldRouter) {
            for (Router.StartEndPath e : foundPipes.values()) {
                e.start = ((IWorldRouter)((Object)start)).getRouter();
            }
        }
        return foundPipes;
    }

    public HashMap<Router, Router.StartEndPath> getResult() {
        return this.result;
    }

    public static void register(ISpecialLinkState link) {
        registeredLSTypes.add(link);
    }

    private static List<asp> getConnections(asp tile) {
        for (ISpecialLinkState link : registeredLSTypes) {
            List linked = link.getLinks(tile);
            if (linked == null) continue;
            return linked;
        }
        return null;
    }
}

