/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import mrtjp.projectred.core.BasicGuiUtils;
import mrtjp.projectred.core.PRColors;
import mrtjp.projectred.core.inventory.GhostGuiScreen;
import mrtjp.projectred.core.inventory.GhostWidget;
import mrtjp.projectred.core.inventory.WidgetButton;
import mrtjp.projectred.core.inventory.WidgetItemSelection;
import mrtjp.projectred.core.inventory.WidgetTextBox;
import mrtjp.projectred.core.utils.ItemKey;
import mrtjp.projectred.core.utils.ItemKeyStack;
import mrtjp.projectred.transportation.IWorldRequester;
import mrtjp.projectred.transportation.TransportationSPH;
import org.lwjgl.input.Keyboard;

public class GuiRequester
extends GhostGuiScreen {
    IWorldRequester pipe;
    WidgetItemSelection itemList;
    WidgetTextBox textFilter;
    WidgetTextBox itemCount;
    WidgetButton.WidgetCheckBox pull;
    WidgetButton.WidgetCheckBox craft;
    WidgetButton.WidgetCheckBox partials;

    public GuiRequester(IWorldRequester pipe) {
        super(280, 230);
        this.itemList = new WidgetItemSelection(this.xSize / 2 - 110, 10, 220, 140);
        this.textFilter = new WidgetTextBox(this.xSize / 2 - 75, 185, 150, 16, ""){

            public void onTextChanged(String oldText) {
                GuiRequester.this.itemList.setNewFilter(this.getText());
            }
        }.setMaxStringLength(24);
        this.itemCount = new WidgetTextBox(this.xSize / 2 - 25, 205, 50, 16, "1"){

            public void mouseScrolled(int x, int y, int scroll) {
                if (this.pointInside(x, y)) {
                    if (scroll > 0) {
                        GuiRequester.this.countUp();
                    } else if (scroll < 0) {
                        GuiRequester.this.countDown();
                    }
                }
            }

            public void onFocusChanged() {
                if (this.getText() == null || this.getText().isEmpty()) {
                    this.setText("1");
                }
            }
        }.setAllowedCharacters("0123456789").setMaxStringLength(7);
        this.pull = new WidgetButton.WidgetCheckBox(230, 170, true){

            public void onStateChanged(boolean oldState) {
                GuiRequester.this.itemList.resetDownloadStats();
                GuiRequester.this.askForListRefresh();
            }
        };
        this.craft = new WidgetButton.WidgetCheckBox(230, 190, true){

            public void onStateChanged(boolean oldState) {
                GuiRequester.this.itemList.resetDownloadStats();
                GuiRequester.this.askForListRefresh();
            }
        };
        this.partials = new WidgetButton.WidgetCheckBox(230, 210, false);
        this.pipe = pipe;
    }

    public void drawBackground() {
        BasicGuiUtils.drawGuiBackGround((atv)this.f, (int)0, (int)0, (int)this.xSize, (int)this.ySize, (float)this.n, (boolean)true);
    }

    public void drawForeground() {
        this.o.a("Pull", 240, 166, PRColors.WHITE.rgb);
        this.o.a("Craft", 240, 186, PRColors.WHITE.rgb);
        this.o.a("Parials", 240, 206, PRColors.WHITE.rgb);
    }

    public void addWidgets() {
        this.add((GhostWidget)this.itemList);
        this.add((GhostWidget)this.textFilter);
        this.add((GhostWidget)this.itemCount);
        this.add((GhostWidget)this.pull);
        this.add((GhostWidget)this.craft);
        this.add((GhostWidget)this.partials);
        this.add((GhostWidget)new WidgetButton.WidgetSimpleButton(10, 185, 50, 16).setActionCommand("refrsh").setText("Re-poll"));
        this.add((GhostWidget)new WidgetButton.WidgetSimpleButton(10, 205, 50, 16).setActionCommand("req").setText("Submit"));
        this.add((GhostWidget)new WidgetButton.WidgetSimpleButton(95, 205, 16, 16).setActionCommand("-").setText("-"));
        this.add((GhostWidget)new WidgetButton.WidgetSimpleButton(170, 205, 16, 16).setActionCommand("+").setText("+"));
        this.add((GhostWidget)new WidgetButton.WidgetSimpleButton(85, 152, 16, 16).setActionCommand("p-").setText("-"));
        this.add((GhostWidget)new WidgetButton.WidgetSimpleButton(180, 152, 16, 16).setActionCommand("p+").setText("+"));
        this.add((GhostWidget)new WidgetButton.WidgetSimpleButton(190, 205, 24, 16).setActionCommand("all").setText("All"));
        this.askForListRefresh();
    }

    private void sendItemRequest() {
        String count = this.itemCount.getText();
        if (count == null || count.isEmpty()) {
            return;
        }
        int amount = Integer.parseInt(count);
        if (amount <= 0) {
            return;
        }
        ItemKeyStack request = this.itemList.getSelection();
        if (request != null) {
            PacketCustom packet = new PacketCustom(TransportationSPH.channel, 8);
            packet.writeCoord(new BlockCoord((asp)this.pipe.getContainer().tile()));
            packet.writeBoolean(this.pull.isChecked());
            packet.writeBoolean(this.craft.isChecked());
            packet.writeBoolean(this.partials.isChecked());
            packet.writeItemStack(request.key().makeStack(amount), true);
            packet.sendToServer();
        }
    }

    private void askForListRefresh() {
        PacketCustom packet = new PacketCustom(TransportationSPH.channel, 10);
        packet.writeCoord(new BlockCoord((asp)this.pipe.getContainer().tile()));
        packet.writeBoolean(this.pull.isChecked());
        packet.writeBoolean(this.craft.isChecked());
        packet.sendToServer();
    }

    private void sendAction(String ident) {
        PacketCustom packet = new PacketCustom(TransportationSPH.channel, 7);
        packet.writeCoord(new BlockCoord((asp)this.pipe.getContainer().tile()));
        packet.writeString(ident);
        packet.sendToServer();
    }

    private void countUp() {
        int current = 0;
        String s = this.itemCount.getText();
        if (s != null && !s.isEmpty()) {
            current = Integer.parseInt(s);
        }
        int newCount = 0;
        newCount = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? current + 10 : current + 1;
        if (String.valueOf(newCount).length() <= this.itemCount.maxStringLength) {
            this.itemCount.setText(String.valueOf(newCount));
        }
    }

    private void countDown() {
        int current = 0;
        String s = this.itemCount.getText();
        if (s != null && !s.isEmpty()) {
            current = Integer.parseInt(s);
        }
        int newCount = 0;
        newCount = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? current - 10 : current - 1;
        if (String.valueOf(newCount = Math.max(1, newCount)).length() <= this.itemCount.maxStringLength) {
            this.itemCount.setText(String.valueOf(newCount));
        }
    }

    public void actionPerformed(String ident, Object ... params) {
        if (ident.equals("req")) {
            this.sendItemRequest();
        } else if (ident.equals("refrsh")) {
            this.itemList.resetDownloadStats();
            this.askForListRefresh();
        } else if (ident.equals("+")) {
            this.countUp();
        } else if (ident.equals("-")) {
            this.countDown();
        } else if (ident.equals("p+")) {
            this.itemList.pageUp();
        } else if (ident.equals("p-")) {
            this.itemList.pageDown();
        } else if (ident.equals("all")) {
            if (this.itemList.getSelection() != null) {
                this.itemCount.setText(String.valueOf(Math.max(1, this.itemList.getSelection().stackSize)));
            }
        } else {
            this.sendAction(ident);
        }
    }

    public void receiveContentList(Map<ItemKey, Integer> content) {
        ArrayList<ItemKeyStack> list = new ArrayList<ItemKeyStack>(content.size());
        for (Map.Entry<ItemKey, Integer> entry : content.entrySet()) {
            list.add(ItemKeyStack.get((ItemKey)entry.getKey(), (int)entry.getValue()));
        }
        Collections.sort(list);
        this.itemList.setDisplayList(list);
    }
}

