/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import openmods.Log;
import openmods.utils.InventoryUtils;
import openmods.utils.MathUtils;

public class OpenModsFakePlayer
extends FakePlayer {
    public OpenModsFakePlayer(World world) {
        super(world, "OpenModsFakePlayer");
    }

    public void func_70106_y() {
        this.field_71071_by.func_82347_b(-1, -1);
        super.func_70106_y();
    }

    public ItemStack equipWithAndRightClick(ItemStack itemStack, Vec3 currentPos, Vec3 hitVector, ForgeDirection side, boolean blockExists) {
        float deltaZ;
        float deltaY;
        float deltaX;
        this.func_70107_b(currentPos.field_72450_a, currentPos.field_72448_b, currentPos.field_72449_c);
        if (blockExists) {
            deltaX = (float)(currentPos.field_72450_a - hitVector.field_72450_a);
            deltaY = (float)(currentPos.field_72448_b - hitVector.field_72448_b);
            deltaZ = (float)(currentPos.field_72449_c - hitVector.field_72449_c);
            this.func_70095_a(false);
            if (this.rightClick(this.field_71071_by.func_70448_g(), (int)currentPos.field_72450_a, (int)currentPos.field_72448_b, (int)currentPos.field_72449_c, side, deltaX, deltaY, deltaZ, blockExists)) {
                this.func_70095_a(true);
                return InventoryUtils.returnItem(this.field_71071_by.func_70448_g());
            }
            hitVector.field_72448_b += 1.0;
            this.func_70095_a(true);
        }
        deltaX = (float)(currentPos.field_72450_a - hitVector.field_72450_a);
        deltaY = (float)(currentPos.field_72448_b - hitVector.field_72448_b);
        deltaZ = (float)(currentPos.field_72449_c - hitVector.field_72449_c);
        float distanceInGroundPlain = (float)Math.sqrt((float)MathUtils.lengthSq(deltaX, deltaZ));
        float pitch = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI);
        float hue = (float)(Math.atan2(deltaY, distanceInGroundPlain) * 180.0 / Math.PI);
        this.func_70101_b(pitch, hue);
        this.field_71071_by.func_82347_b(-1, -1);
        this.field_71071_by.func_70441_a(itemStack);
        this.rightClick(this.field_71071_by.func_70448_g(), (int)currentPos.field_72450_a, (int)currentPos.field_72448_b, (int)currentPos.field_72449_c, side, deltaX, deltaY, deltaZ, blockExists);
        return InventoryUtils.returnItem(this.field_71071_by.func_70448_g());
    }

    public void dropItemAt(ItemStack itemStack, int x, int y, int z, ForgeDirection direction) {
        this.func_70107_b((float)x + 0.5f, (double)y - 1.5, (float)z + 0.5f);
        Preconditions.checkArgument((direction == ForgeDirection.DOWN ? 1 : 0) != 0, (Object)"Other directions than down is not implemented");
        this.func_70101_b(0.0f, 90.0f);
        EntityItem entityItem = this.func_71021_b(itemStack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.0;
        entityItem.field_70179_y = 0.0;
    }

    private boolean rightClick(ItemStack itemStack, int x, int y, int z, ForgeDirection side, float deltaX, float deltaY, float deltaZ, boolean blockExists) {
        int blockId;
        Block block;
        if (itemStack == null) {
            return false;
        }
        int opposite = side.getOpposite().ordinal();
        PlayerInteractEvent event = ForgeEventFactory.onPlayerInteract((EntityPlayer)this, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, (int)x, (int)y, (int)z, (int)opposite);
        if (event.isCanceled()) {
            return false;
        }
        Item usedItem = itemStack.func_77973_b();
        if (usedItem.onItemUseFirst(itemStack, (EntityPlayer)this, this.field_70170_p, x, y, z, opposite, deltaX, deltaY, deltaZ)) {
            return true;
        }
        if (event.useBlock != Event.Result.DENY && (this.func_70093_af() || usedItem.shouldPassSneakingClickToBlock(this.field_70170_p, x, y, z)) && (block = Block.field_71973_m[blockId = this.field_70170_p.func_72798_a(x, y, z)]) != null) {
            try {
                if (block.func_71903_a(this.field_70170_p, x, y, z, (EntityPlayer)this, opposite, deltaX, deltaY, deltaZ)) {
                    return true;
                }
            }
            catch (Throwable t) {
                Log.warn(t, "Invalid use of fake player on block %s @ (%d,%d,%d), aborting. Don't do it again", block, x, y, z);
            }
        }
        if (event.useItem == Event.Result.DENY || usedItem instanceof ItemBlock && blockExists) {
            return false;
        }
        try {
            return itemStack.func_77943_a((EntityPlayer)this, this.field_70170_p, x, y, z, opposite, deltaX, deltaY, deltaZ);
        }
        catch (Throwable t) {
            Log.warn(t, "Invalid use of fake player with item %s @ (%d,%d,%d), aborting. Don't do it again", usedItem, x, y, z);
            return false;
        }
    }
}

