/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.ForgeDirection;

public class Coord
implements Cloneable {
    public final int x;
    public final int y;
    public final int z;

    public Coord(ForgeDirection direction) {
        this.x = direction.offsetX;
        this.y = direction.offsetY;
        this.z = direction.offsetZ;
    }

    public Coord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coord(double x, double y, double z) {
        this.x = MathHelper.func_76128_c((double)x);
        this.y = MathHelper.func_76128_c((double)y);
        this.z = MathHelper.func_76128_c((double)z);
    }

    public Coord(int[] coords) {
        this.x = coords[0];
        this.y = coords[1];
        this.z = coords[2];
    }

    public Coord(ChunkPosition pos) {
        this.x = pos.field_76930_a;
        this.y = pos.field_76928_b;
        this.z = pos.field_76929_c;
    }

    public Coord offset(ForgeDirection direction) {
        return new Coord(this.x + direction.offsetX, this.y + direction.offsetY, this.z + direction.offsetZ);
    }

    public Coord offset(int ox, int oy, int oz) {
        return new Coord(this.x + ox, this.y + oy, this.z + oz);
    }

    public int hashCode() {
        return this.x + 128 << 16 | this.y + 128 << 8 | this.z + 128;
    }

    public boolean equals(Object that) {
        if (!(that instanceof Coord)) {
            return false;
        }
        Coord otherCoord = (Coord)that;
        return otherCoord.x == this.x && otherCoord.y == this.y && otherCoord.z == this.z;
    }

    public String toString() {
        return String.format("%s,%s,%s", this.x, this.y, this.z);
    }

    public Coord clone() {
        return new Coord(this.x, this.y, this.z);
    }

    public ChunkPosition asChunkPosition() {
        return new ChunkPosition(this.x, this.y, this.z);
    }

    public Coord add(Coord other) {
        return new Coord(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Coord substract(Coord other) {
        return new Coord(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public int lengthSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.lengthSq());
    }

    public Coord getAdjacentCoord(ForgeDirection fd) {
        return this.getOffsetCoord(fd, 1);
    }

    public Coord getOffsetCoord(ForgeDirection fd, int distance) {
        return new Coord(this.x + fd.offsetX * distance, this.y + fd.offsetY * distance, this.z + fd.offsetZ * distance);
    }

    public Coord[] getDirectlyAdjacentCoords() {
        return this.getDirectlyAdjacentCoords(true);
    }

    public Coord[] getDirectlyAdjacentCoords(boolean includeBelow) {
        Coord[] adjacents = includeBelow ? new Coord[6] : new Coord[]{this.getAdjacentCoord(ForgeDirection.UP), this.getAdjacentCoord(ForgeDirection.NORTH), this.getAdjacentCoord(ForgeDirection.EAST), this.getAdjacentCoord(ForgeDirection.SOUTH), this.getAdjacentCoord(ForgeDirection.WEST)};
        if (includeBelow) {
            adjacents[5] = this.getAdjacentCoord(ForgeDirection.DOWN);
        }
        return adjacents;
    }

    public Coord[] getAdjacentCoords() {
        return this.getAdjacentCoords(true, true);
    }

    public Coord[] getAdjacentCoords(boolean includeBelow, boolean includeDiagonal) {
        if (!includeDiagonal) {
            return this.getDirectlyAdjacentCoords(includeBelow);
        }
        Coord[] adjacents = new Coord[includeBelow ? 26 : 17];
        int index = 0;
        for (int xl = -1; xl < 1; ++xl) {
            for (int zl = -1; zl < 1; ++zl) {
                int yl;
                int n = yl = includeBelow ? -1 : 0;
                while (yl < 1) {
                    if (xl != 0 || zl != 0 || yl != 0) {
                        adjacents[index++] = new Coord(this.x + xl, this.y + yl, this.z + zl);
                    }
                    ++yl;
                }
            }
        }
        return adjacents;
    }

    public boolean isAbove(Coord pos) {
        return pos != null ? this.y > pos.y : false;
    }

    public boolean isBelow(Coord pos) {
        return pos != null ? this.y < pos.y : false;
    }

    public boolean isNorthOf(Coord pos) {
        return pos != null ? this.z < pos.z : false;
    }

    public boolean isSouthOf(Coord pos) {
        return pos != null ? this.z > pos.z : false;
    }

    public boolean isEastOf(Coord pos) {
        return pos != null ? this.x > pos.x : false;
    }

    public boolean isWestOf(Coord pos) {
        return pos != null ? this.x < pos.x : false;
    }

    public boolean isXAligned(Coord pos) {
        return pos != null ? this.x == pos.x : false;
    }

    public boolean isYAligned(Coord pos) {
        return pos != null ? this.y == pos.y : false;
    }

    public boolean isZAligned(Coord pos) {
        return pos != null ? this.z == pos.z : false;
    }
}

