/*
 * Decompiled with CFR 0.152.
 */
package openmods.integration;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.Loader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import openmods.integration.ModuleBuildCraft;

public class Integration {
    @Module(modId="BuildCraft|Core", live=ModuleBuildCraft.ModuleBuildCraftLive.class)
    private static ModuleBuildCraft buildCraft = new ModuleBuildCraft();

    public static ModuleBuildCraft modBuildCraft() {
        return buildCraft;
    }

    public static void selectModules() {
        for (Field f : Integration.class.getDeclaredFields()) {
            Module mod = f.getAnnotation(Module.class);
            if (mod == null || !Loader.isModLoaded((String)mod.modId())) continue;
            try {
                Class<?> liveReplacementCls = mod.live();
                f.setAccessible(true);
                Object replacement = liveReplacementCls.newInstance();
                f.set(null, replacement);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Module {
        public String modId();

        public Class<?> live();
    }
}

