/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.toposort.TopologicalSort;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeSorter
implements Comparator<aah> {
    private static Map<Class, Category> categories = Maps.newHashMap();
    private static Map<String, Class> types = Maps.newHashMap();
    private static Map<String, SortEntry> entries = Maps.newHashMap();
    private static Map<Class, Integer> priorities = Maps.newHashMap();
    public static RecipeSorter INSTANCE = new RecipeSorter();
    private static boolean isDirty = true;
    private static SortEntry before = new SortEntry("Before", null, Category.UNKNOWN, "");
    private static SortEntry after = new SortEntry("After", null, Category.UNKNOWN, "");
    private static Set<Class> warned = Sets.newHashSet();

    private RecipeSorter() {
        RecipeSorter.register("minecraft:shaped", aai.class, Category.SHAPED, "before:minecraft:shapeless");
        RecipeSorter.register("minecraft:mapextending", aad.class, Category.SHAPED, "after:minecraft:shaped before:minecraft:shapeless");
        RecipeSorter.register("minecraft:shapeless", aaj.class, Category.SHAPELESS, "after:minecraft:shaped");
        RecipeSorter.register("minecraft:fireworks", zz.class, Category.SHAPELESS, "after:minecraft:shapeless");
        RecipeSorter.register("minecraft:armordyes", zw.class, Category.SHAPELESS, "after:minecraft:shapeless");
        RecipeSorter.register("minecraft:mapcloning", aac.class, Category.SHAPELESS, "after:minecraft:shapeless");
        RecipeSorter.register("forge:shapedore", ShapedOreRecipe.class, Category.SHAPED, "after:minecraft:shaped before:minecraft:shapeless");
        RecipeSorter.register("forge:shapelessore", ShapelessOreRecipe.class, Category.SHAPELESS, "after:minecraft:shapeless");
    }

    @Override
    public int compare(aah r1, aah r2) {
        Category c1 = RecipeSorter.getCategory(r1);
        Category c2 = RecipeSorter.getCategory(r2);
        if (c1 == Category.SHAPELESS && c2 == Category.SHAPED) {
            return 1;
        }
        if (c1 == Category.SHAPED && c2 == Category.SHAPELESS) {
            return -1;
        }
        if (r2.a() < r1.a()) {
            return -1;
        }
        if (r2.a() > r1.a()) {
            return 1;
        }
        return RecipeSorter.getPriority(r2) - RecipeSorter.getPriority(r1);
    }

    public static void sortCraftManager() {
        RecipeSorter.bake();
        FMLLog.fine("Sorting recipies", new Object[0]);
        warned.clear();
        Collections.sort(aaf.a().b(), INSTANCE);
    }

    public static void register(String name, Class recipe, Category category, String dependancies) {
        assert (category != Category.UNKNOWN) : "Category must not be unknown!";
        isDirty = true;
        SortEntry entry = new SortEntry(name, recipe, category, dependancies);
        entries.put(name, entry);
        RecipeSorter.setCategory(recipe, category);
    }

    public static void setCategory(Class recipe, Category category) {
        assert (category != Category.UNKNOWN) : "Category must not be unknown!";
        categories.put(recipe, category);
    }

    public static Category getCategory(aah recipe) {
        return RecipeSorter.getCategory(recipe.getClass());
    }

    public static Category getCategory(Class recipe) {
        Class cls = recipe;
        Category ret = categories.get(cls);
        if (ret == null) {
            cls = cls.getSuperclass();
            while (cls != Object.class) {
                ret = categories.get(cls);
                if (ret == null) continue;
                categories.put(recipe, ret);
                return ret;
            }
        }
        return ret == null ? Category.UNKNOWN : ret;
    }

    private static int getPriority(aah recipe) {
        Class<?> cls = recipe.getClass();
        Integer ret = priorities.get(cls);
        if (ret == null) {
            if (!warned.contains(cls)) {
                FMLLog.fine("  Unknown recipe class! %s Modder please refer to %s", cls.getName(), RecipeSorter.class.getName());
                warned.add(cls);
            }
            cls = cls.getSuperclass();
            while (cls != Object.class) {
                ret = priorities.get(cls);
                if (ret == null) continue;
                priorities.put(recipe.getClass(), ret);
                FMLLog.fine("    Parent Found: %d - %s", (int)ret, cls.getName());
                return ret;
            }
        }
        return ret == null ? 0 : ret;
    }

    private static void bake() {
        if (!isDirty) {
            return;
        }
        FMLLog.fine("Forge RecipeSorter Baking:", new Object[0]);
        TopologicalSort.DirectedGraph<SortEntry> sorter = new TopologicalSort.DirectedGraph<SortEntry>();
        sorter.addNode(before);
        sorter.addNode(after);
        sorter.addEdge(before, after);
        for (Map.Entry<String, SortEntry> entry : entries.entrySet()) {
            sorter.addNode(entry.getValue());
        }
        for (Map.Entry<String, SortEntry> e : entries.entrySet()) {
            SortEntry entry = e.getValue();
            boolean postAdded = false;
            sorter.addEdge(before, entry);
            for (String dep : entry.after) {
                if (!entries.containsKey(dep)) continue;
                sorter.addEdge(entries.get(dep), entry);
            }
            for (String dep : entry.before) {
                postAdded = true;
                sorter.addEdge(entry, after);
                if (!entries.containsKey(dep)) continue;
                sorter.addEdge(entry, entries.get(dep));
            }
            if (postAdded) continue;
            sorter.addEdge(entry, after);
        }
        List<SortEntry> sorted = TopologicalSort.topologicalSort(sorter);
        int x = sorted.size();
        for (SortEntry entry : sorted) {
            FMLLog.fine("  %d: %s", x, entry);
            priorities.put(entry.cls, x--);
        }
    }

    private static class SortEntry {
        private String name;
        private Class cls;
        private Category cat;
        List<String> before = Lists.newArrayList();
        List<String> after = Lists.newArrayList();

        private SortEntry(String name, Class cls, Category cat, String deps) {
            this.name = name;
            this.cls = cls;
            this.cat = cat;
            this.parseDepends(deps);
        }

        private void parseDepends(String deps) {
            if (deps.isEmpty()) {
                return;
            }
            for (String dep : deps.split(" ")) {
                if (dep.startsWith("before:")) {
                    this.before.add(dep.substring(7));
                    continue;
                }
                if (dep.startsWith("after:")) {
                    this.after.add(dep.substring(6));
                    continue;
                }
                throw new IllegalArgumentException("Invalid dependancy: " + dep);
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("RecipeEntry(\"").append(this.name).append("\", ");
            buf.append(this.cat.name()).append(", ");
            buf.append(this.cls == null ? "" : this.cls.getName()).append(")");
            if (this.before.size() > 0) {
                buf.append(" Before: ").append(Joiner.on((String)", ").join(this.before));
            }
            if (this.after.size() > 0) {
                buf.append(" After: ").append(Joiner.on((String)", ").join(this.after));
            }
            return buf.toString();
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static enum Category {
        UNKNOWN,
        SHAPELESS,
        SHAPED;

    }
}

