/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.sensors;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import openperipheral.adapter.PeripheralHandlers;
import openperipheral.addons.OpenPeripheralAddons;
import openperipheral.addons.sensors.ISensorEnvironment;

public class TurtleUpgradeSensor
implements ITurtleUpgrade {
    public int getUpgradeID() {
        return 180;
    }

    public String getAdjective() {
        return StatCollector.func_74838_a((String)"openperipheral.turtle.sensor.adjective");
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public ItemStack getCraftingItem() {
        return new ItemStack((Block)OpenPeripheralAddons.Blocks.sensor);
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return PeripheralHandlers.createPeripheral((Object)new TurtleSensorEnvironment(turtle));
    }

    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int direction) {
        return null;
    }

    public Icon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return OpenPeripheralAddons.Blocks.sensor.turtleIcon;
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
    }

    private static class TurtleSensorEnvironment
    implements ISensorEnvironment {
        private ITurtleAccess turtle;

        public TurtleSensorEnvironment(ITurtleAccess turtle) {
            this.turtle = turtle;
        }

        @Override
        public boolean isTurtle() {
            return true;
        }

        @Override
        public ChunkCoordinates getLocation() {
            return this.turtle.getPosition();
        }

        public World getWorld() {
            return this.turtle.getWorld();
        }

        @Override
        public int getSensorRange() {
            return 30;
        }
    }
}

