/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.sensors;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import openperipheral.addons.sensors.ISensorEnvironment;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaType;
import openperipheral.api.OnTick;
import openperipheral.api.Prefixed;
import openperipheral.util.EntityUtils;

@OnTick
@Prefixed(value={"target"})
public class AdapterSensor
implements IPeripheralAdapter {
    public Class<?> getTargetClass() {
        return ISensorEnvironment.class;
    }

    private static AxisAlignedBB getBoundingBox(ChunkCoordinates location, double range) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)location.field_71574_a, (double)location.field_71572_b, (double)location.field_71573_c, (double)(location.field_71574_a + 1), (double)(location.field_71572_b + 1), (double)(location.field_71573_c + 1)).func_72314_b(range, range, range);
    }

    private static List<Integer> listEntities(ISensorEnvironment env, Class<? extends Entity> entityClass) {
        List mobs = env.getWorld().func_72872_a(entityClass, AdapterSensor.getBoundingBox(env.getLocation(), env.getSensorRange()));
        ArrayList ids = Lists.newArrayList();
        for (EntityLiving mob : mobs) {
            ids.add(mob.field_70157_k);
        }
        return ids;
    }

    private static Map<String, Object> getEntityInfo(ISensorEnvironment sensor, int mobId) {
        Entity mob = sensor.getWorld().func_73045_a(mobId);
        return mob != null ? EntityUtils.entityToMap((Entity)mob, (ChunkCoordinates)sensor.getLocation()) : null;
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get the usernames of all the players in range")
    public List<String> getPlayerNames(ISensorEnvironment env) {
        List players = env.getWorld().func_72872_a(EntityPlayer.class, AdapterSensor.getBoundingBox(env.getLocation(), env.getSensorRange()));
        ArrayList names = Lists.newArrayList();
        for (EntityPlayer player : players) {
            names.add(player.field_71092_bJ);
        }
        return names;
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get the ids of all the mobs in range")
    public List<Integer> getMobIds(ISensorEnvironment env) {
        return AdapterSensor.listEntities(env, EntityLiving.class);
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get the ids of all the minecarts in range")
    public List<Integer> getMinecartIds(ISensorEnvironment env) {
        return AdapterSensor.listEntities(env, EntityMinecart.class);
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get full details of a particular player if they're in range")
    public Map<?, ?> getPlayerData(ISensorEnvironment env, @Arg(type=LuaType.STRING, name="username", description="The players username") String username) {
        EntityPlayer player = env.getWorld().func_72924_a(username);
        return player != null ? EntityUtils.entityToMap((Entity)player, (ChunkCoordinates)env.getLocation()) : null;
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get full details of a particular mob if it's in range")
    public Map<String, Object> getMobData(ISensorEnvironment sensor, @Arg(type=LuaType.NUMBER, name="mobId", description="The mob id retrieved from getMobIds()") int mobId) {
        return AdapterSensor.getEntityInfo(sensor, mobId);
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get full details of a particular minecart if it's in range")
    public Map<?, ?> getMinecartData(ISensorEnvironment sensor, @Arg(type=LuaType.NUMBER, name="minecartId", description="The minecart id retrieved from getMobIds()") int minecartId) {
        return AdapterSensor.getEntityInfo(sensor, minecartId);
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get a table of information about the surrounding area. Includes whether each block is UNKNOWN, AIR, LIQUID or SOLID")
    public Map<Integer, Map<String, Object>> sonicScan(ISensorEnvironment env) {
        int range = 1 + env.getSensorRange() / 2;
        World world = env.getWorld();
        HashMap results = Maps.newHashMap();
        ChunkCoordinates sensorPos = env.getLocation();
        int sx = sensorPos.field_71574_a;
        int sy = sensorPos.field_71572_b;
        int sz = sensorPos.field_71573_c;
        int rangeSq = range * range;
        int i = 0;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    int distSq;
                    int bx = sx + x;
                    int by = sy + y;
                    int bz = sz + z;
                    if (!world.func_72899_e(bx, by, bz) || (distSq = x * x + y * y + z * z) == 0 || distSq > rangeSq) continue;
                    int id = world.func_72798_a(bx, by, bz);
                    Block block = Block.field_71973_m[id];
                    String type = block == null || world.func_72799_c(bx, by, bz) ? "AIR" : (block.field_72018_cp.func_76224_d() ? "LIQUID" : (block.field_72018_cp.func_76220_a() ? "SOLID" : "UNKNOWN"));
                    HashMap tmp = Maps.newHashMap();
                    tmp.put("x", x);
                    tmp.put("y", y);
                    tmp.put("z", z);
                    tmp.put("type", type);
                    results.put(++i, tmp);
                }
            }
        }
        return results;
    }
}

