/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.peripheralproxy;

import dan200.computercraft.api.peripheral.IPeripheral;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openmods.Log;
import openmods.api.INeighbourAwareTile;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.ReflectionHelper;
import openperipheral.addons.OpenPeripheralAddons;
import openperipheral.addons.peripheralproxy.WrappedPeripheral;
import openperipheral.api.ICustomPeripheralProvider;
import openperipheral.api.Volatile;
import org.apache.commons.lang3.ArrayUtils;

@Volatile
public class TileEntityPeripheralProxy
extends OpenTileEntity
implements ICustomPeripheralProvider,
INeighbourAwareTile {
    public static final ReflectionHelper.SafeClassLoad CC_CLASS = ReflectionHelper.safeLoad((String)"dan200.computercraft.ComputerCraft");
    public static final ReflectionHelper.SafeClassLoad CABLE_CLASS = ReflectionHelper.safeLoad((String)"dan200.computercraft.shared.peripheral.modem.TileCable");

    public IPeripheral createPeripheral(int side) {
        ForgeDirection rotation = this.getRotation();
        if (rotation.getOpposite().ordinal() != side) {
            return null;
        }
        IPeripheral peripheral = (IPeripheral)ReflectionHelper.callStatic((Class)CC_CLASS.get(), (String)"getPeripheralAt", (Object[])new Object[]{ReflectionHelper.typed((Object)this.field_70331_k, World.class), ReflectionHelper.primitive((int)(this.field_70329_l + rotation.offsetX)), ReflectionHelper.primitive((int)(this.field_70330_m + rotation.offsetY)), ReflectionHelper.primitive((int)(this.field_70327_n + rotation.offsetZ)), ReflectionHelper.primitive((int)0)});
        return peripheral != null ? new WrappedPeripheral(peripheral) : null;
    }

    public void onNeighbourChanged(int blockId) {
        if (!this.field_70331_k.field_72995_K) {
            ForgeDirection targetDir = this.getRotation();
            boolean isConnected = this.isProxyActive(targetDir);
            ForgeDirection modemDir = targetDir.getOpposite();
            this.updateModem(modemDir, isConnected);
        }
    }

    private boolean isProxyActive(ForgeDirection targetDir) {
        int targetX = this.field_70329_l + targetDir.offsetX;
        int targetY = this.field_70330_m + targetDir.offsetY;
        int targetZ = this.field_70327_n + targetDir.offsetZ;
        return this.field_70331_k.func_72796_p(targetX, targetY, targetZ) != null;
    }

    private void updateModem(ForgeDirection modemDir, boolean reactivate) {
        int attachedX = this.field_70329_l + modemDir.offsetX;
        int attachedY = this.field_70330_m + modemDir.offsetY;
        int attachedZ = this.field_70327_n + modemDir.offsetZ;
        TileEntity attachedModem = this.field_70331_k.func_72796_p(attachedX, attachedY, attachedZ);
        try {
            Class cableCls = CABLE_CLASS.get();
            if (attachedModem != null && cableCls.isAssignableFrom(attachedModem.getClass())) {
                Field f = ReflectionHelper.getField((Class)cableCls, (String[])new String[]{"m_peripheralAccessAllowed"});
                f.setAccessible(true);
                boolean isActive = f.getBoolean(attachedModem);
                if (isActive) {
                    Method m = ReflectionHelper.getMethod((Class)cableCls, (String[])((String[])ArrayUtils.toArray((Object[])new String[]{"togglePeripheralAccess"})), (Class[])new Class[0]);
                    m.setAccessible(true);
                    m.invoke((Object)attachedModem, new Object[0]);
                    if (reactivate) {
                        m.invoke((Object)attachedModem, new Object[0]);
                    }
                }
            }
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Failed to update modem %s", (Object[])new Object[]{attachedModem});
        }
        this.field_70331_k.func_72821_m(attachedX, attachedY, attachedZ, OpenPeripheralAddons.Blocks.peripheralProxy.field_71990_ca);
    }
}

