/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import openmods.tileentity.OpenTileEntity;
import openperipheral.adapter.AdapterManager;
import openperipheral.addons.glasses.GlassesRenderingUtils;
import openperipheral.addons.glasses.SurfaceServer;
import openperipheral.addons.glasses.TerminalEvent;
import openperipheral.addons.glasses.TerminalManagerServer;
import openperipheral.addons.glasses.TerminalUtils;
import openperipheral.api.Arg;
import openperipheral.api.Freeform;
import openperipheral.api.IAttachable;
import openperipheral.api.Include;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaType;

@Freeform
public class TileEntityGlassesBridge
extends OpenTileEntity
implements IAttachable {
    private static final String EVENT_CHAT_MESSAGE = "chat_command";
    private static final String EVENT_PLAYER_JOIN = "registered_player_join";
    private final Map<String, PlayerInfo> knownPlayers = Maps.newHashMap();
    private final Set<EntityPlayer> newPlayers = Sets.newSetFromMap(new WeakHashMap());
    private List<IComputerAccess> computers = Lists.newArrayList();
    public SurfaceServer globalSurface = new SurfaceServer("GLOBAL");
    private long guid = TerminalUtils.generateGuid();

    public void registerTerminal(EntityPlayer player) {
        if (!this.knownPlayers.containsKey(player.func_70023_ak())) {
            this.newPlayers.add(player);
        }
    }

    public void onChatCommand(String command, String username) {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent(EVENT_CHAT_MESSAGE, new Object[]{command, username, this.guid, computer.getAttachmentName()});
        }
    }

    public void func_70312_q() {
        super.func_70312_q();
        TerminalManagerServer.instance.registerBridge(this.guid, this);
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.field_70331_k.field_72995_K || this.globalSurface == null) {
            return;
        }
        TerminalEvent.TerminalDataEvent globalChange = null;
        boolean globalUpdate = this.globalSurface.hasUpdates();
        Iterator<PlayerInfo> it = this.knownPlayers.values().iterator();
        while (it.hasNext()) {
            SurfaceServer privateSurface;
            PlayerInfo info = it.next();
            EntityPlayer player = (EntityPlayer)info.player.get();
            if (!this.isPlayerValid(player)) {
                it.remove();
                continue;
            }
            if (globalUpdate) {
                if (globalChange == null) {
                    globalChange = TerminalManagerServer.createUpdateDataEvent(this.globalSurface, this.guid, false);
                }
                globalChange.sendToPlayer(player);
            }
            if ((privateSurface = info.surface) == null || !privateSurface.hasUpdates()) continue;
            TerminalEvent.TerminalDataEvent privateData = TerminalManagerServer.createUpdateDataEvent(privateSurface, this.guid, true);
            privateData.sendToPlayer(player);
        }
        TerminalEvent.TerminalDataEvent globalFull = null;
        for (EntityPlayer newPlayer : this.newPlayers) {
            if (!this.isPlayerValid(newPlayer)) continue;
            if (globalFull == null) {
                globalFull = TerminalManagerServer.createFullDataEvent(this.globalSurface, this.guid, false);
            }
            globalFull.sendToPlayer(newPlayer);
            String playerName = newPlayer.func_70023_ak();
            this.knownPlayers.put(playerName, new PlayerInfo(this, newPlayer));
            this.onPlayerJoin(playerName);
        }
        this.newPlayers.clear();
    }

    private boolean isPlayerValid(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (player.field_70128_L && !TileEntityGlassesBridge.isPlayerLogged(player)) {
            return false;
        }
        Long guid = TerminalUtils.tryGetTerminalGuid(player);
        return guid != null && guid == this.guid;
    }

    private static boolean isPlayerLogged(EntityPlayer player) {
        List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayer p : players) {
            if (!p.field_71092_bJ.equals(player.field_71092_bJ)) continue;
            return true;
        }
        return false;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74772_a("guid", this.guid);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        Long guid = TerminalUtils.extractGuid(tag);
        if (guid != null) {
            this.guid = guid;
        }
    }

    public void onPlayerJoin(String playerName) {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent(EVENT_PLAYER_JOIN, new Object[]{playerName});
        }
    }

    public void addComputer(IComputerAccess computer) {
        if (!this.computers.contains(computer)) {
            this.computers.add(computer);
        }
    }

    public void removeComputer(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public SurfaceServer getSurface(String username) {
        if ("GLOBAL".equals(username)) {
            return this.globalSurface;
        }
        PlayerInfo info = this.knownPlayers.get(username);
        return info != null ? info.surface : null;
    }

    @LuaCallable(returnTypes={LuaType.TABLE}, description="Get the names of all the users linked up to this bridge")
    public List<String> getUsers() {
        return ImmutableList.copyOf(this.knownPlayers.keySet());
    }

    @LuaCallable(returnTypes={LuaType.STRING}, name="getGuid", description="Get the Guid of this bridge")
    public String getGuidString() {
        return TerminalUtils.formatTerminalId(this.guid);
    }

    public long getGuid() {
        return this.guid;
    }

    @LuaCallable(returnTypes={LuaType.NUMBER}, description="Get the display width of some text")
    public int getStringWidth(@Arg(name="text", description="The text you want to measure", type=LuaType.STRING) String text) {
        return GlassesRenderingUtils.getStringWidth(text);
    }

    @LuaCallable(returnTypes={LuaType.OBJECT}, description="Get the surface of a user to draw privately on their screen")
    public ILuaObject getUserSurface(@Arg(name="username", description="The username of the user to get the draw surface for", type=LuaType.STRING) String username) {
        return AdapterManager.wrapObject((Object)((Object)this.getSurface(username)));
    }

    @Include
    public SurfaceServer getGlobalSurface() {
        return this.globalSurface;
    }

    private static class PlayerInfo {
        public final WeakReference<EntityPlayer> player;
        public SurfaceServer surface;

        public PlayerInfo(TileEntityGlassesBridge parent, EntityPlayer player) {
            this.player = new WeakReference<EntityPlayer>(player);
            this.surface = new SurfaceServer(player.func_70023_ak());
        }
    }
}

