/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import openmods.network.EventPacket;
import openmods.network.IEventPacketType;
import openmods.structured.Command;
import openperipheral.addons.EventTypes;
import openperipheral.addons.glasses.TerminalUtils;

public abstract class TerminalEvent
extends EventPacket {
    public long terminalId;
    public boolean isPrivate;

    public TerminalEvent() {
    }

    public TerminalEvent(long terminalId, boolean isPrivate) {
        this.terminalId = terminalId;
        this.isPrivate = isPrivate;
    }

    protected void readFromStream(DataInput input) throws IOException {
        this.terminalId = input.readLong();
        this.isPrivate = input.readBoolean();
    }

    protected void writeToStream(DataOutput output) throws IOException {
        output.writeLong(this.terminalId);
        output.writeBoolean(this.isPrivate);
    }

    protected void appendLogInfo(List<String> info) {
        super.appendLogInfo(info);
        info.add(TerminalUtils.formatTerminalId(this.terminalId));
        info.add(this.isPrivate ? "private" : "public");
    }

    public static class TerminalDataEvent
    extends TerminalEvent {
        public final Command.CommandList commands = new Command.CommandList();

        public TerminalDataEvent() {
        }

        public TerminalDataEvent(long terminalId, boolean isPrivate) {
            super(terminalId, isPrivate);
        }

        public IEventPacketType getType() {
            return EventTypes.TERMINAL_DATA;
        }

        @Override
        protected void readFromStream(DataInput input) throws IOException {
            super.readFromStream(input);
            this.commands.readFromStream(input);
        }

        @Override
        protected void writeToStream(DataOutput output) throws IOException {
            super.writeToStream(output);
            this.commands.writeToStream(output);
        }

        @Override
        protected void appendLogInfo(List<String> info) {
            super.appendLogInfo(info);
            info.add(Integer.toString(this.commands.size()));
        }
    }

    public static class TerminalResetEvent
    extends TerminalEvent {
        public TerminalResetEvent() {
        }

        public TerminalResetEvent(long terminalId, boolean isPrivate) {
            super(terminalId, isPrivate);
        }

        public IEventPacketType getType() {
            return EventTypes.TERMINAL_RESET;
        }
    }
}

