/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.compat;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.IAllele;
import magicbees.bees.BeeManager;
import magicbees.main.Config;
import net.minecraft.block.Block;

public class ForestryHelper {
    public static final String Name = "Forestry";

    public static void preInit() {
    }

    public static void init() {
        ForestryHelper.getBlocks();
        ForestryHelper.getItems();
    }

    public static void postInit() {
    }

    private static void getBlocks() {
        try {
            Class<?> c = Class.forName("forestry.core.config.ForestryBlock");
            Config.fAlvearyBlock = (Block)c.getField("alveary").get(null);
            Config.fHiveBlock = (Block)c.getField("beehives").get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void getItems() {
        Config.fBeeComb = ItemInterface.getItem((String)"beeComb").func_77973_b();
        Config.fPollen = ItemInterface.getItem((String)"pollen").func_77973_b();
        Config.fCraftingResource = ItemInterface.getItem((String)"craftingMaterial").func_77973_b();
        Config.fHoneyDrop = ItemInterface.getItem((String)"honeyDrop").func_77973_b();
        Config.fHoneydew = ItemInterface.getItem((String)"honeydew").func_77973_b();
    }

    public static IAllele[] getTemplateForestryForSpecies(String speciesName) {
        return BeeManager.beeRoot.getTemplate("forestry.species" + speciesName);
    }

    public static EnumTemperature getEnumTemperatureFromValue(float rawTemp) {
        return EnumTemperature.getFromValue((float)rawTemp);
    }

    public static EnumHumidity getEnumHumidityFromValue(float rawHumidity) {
        return EnumHumidity.getFromValue((float)rawHumidity);
    }

    public static enum Tube {
        COPPER,
        TIN,
        BRONZE,
        IRON,
        GOLD,
        DIAMOND,
        OBSIDIAN,
        BLAZE,
        RUBBER,
        EMERALD,
        APATITE,
        LAPIS;

    }

    public static enum CircuitBoard {
        BASIC,
        ENHANCED,
        REFINED,
        INTRICATE;

    }

    public static enum Pollen {
        NORMAL,
        CRYSTALLINE;

    }

    public static enum Propolis {
        NORMAL,
        STICKY,
        PULSATING,
        SILKY;

    }

    public static enum Comb {
        HONEY,
        COCOA,
        SIMMERING,
        STRINGY,
        FROZEN,
        DRIPPING,
        SILKY,
        PARCHED,
        MYSTERIOUS,
        IRRADIATED,
        POWDERY,
        REDDENED,
        DARKENED,
        OMEGA,
        WHEATEN,
        MOSSY;

    }

    public static enum CraftingMaterial {
        PULSATING_DUST,
        PULSATING_MESH,
        SILK_WISP,
        WOVEN_SILK,
        DISSIPATION_CHARGE,
        ICE_SHARD,
        SCENTED_PANELING;

    }

    public static enum BlockResource {
        APATITE,
        COPPER,
        TIN;

    }
}

