/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.PRColors;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHalo {
    public static RenderHalo instance = new RenderHalo();
    private static List<LightCache> renderList = new ArrayList<LightCache>();
    private static Vector3 renderEntityPos = new Vector3();
    private static Vector3 vec = new Vector3();

    public static void addLight(int x, int y, int z, int color, Cuboid6 box) {
        renderList.add(new LightCache(x, y, z, color, box));
    }

    @ForgeSubscribe
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        bfq tess = bfq.a;
        bdd w = event.context.k;
        of entity = event.context.t.i;
        renderEntityPos.set(entity.u, entity.v + (double)entity.f(), entity.w);
        Collections.sort(renderList);
        GL11.glPushMatrix();
        RenderUtils.translateToWorldCoords((nn)event.context.t.i, (float)event.partialTicks);
        RenderHalo.prepareRenderState();
        Iterator<LightCache> it = renderList.iterator();
        int max = Configurator.lightHaloMax < 0 ? renderList.size() : Configurator.lightHaloMax;
        for (int i = 0; i < max && it.hasNext(); ++i) {
            LightCache cc = it.next();
            RenderHalo.renderHalo(tess, (abw)w, cc);
        }
        renderList.clear();
        RenderHalo.restoreRenderState();
        GL11.glPopMatrix();
    }

    public static void prepareRenderState() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        CCRenderState.reset();
        CCRenderState.startDrawing((int)7);
    }

    public static void restoreRenderState() {
        CCRenderState.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
    }

    private static void renderHalo(bfq tess, abw world, LightCache cc) {
        CCRenderState.setBrightness((acf)world, (int)cc.pos.x, (int)cc.pos.y, (int)cc.pos.z);
        RenderHalo.renderHalo(tess, cc.cube, cc.color, (Transformation)new Translation((double)cc.pos.x, (double)cc.pos.y, (double)cc.pos.z));
    }

    public static void renderHalo(bfq tess, Cuboid6 cuboid, int colour, Transformation t) {
        tess.a(PRColors.VALID_COLORS[colour].rgb, 128);
        RenderUtils.renderBlock((Cuboid6)cuboid, (int)0, (Transformation)t, null, null);
    }

    private static class LightCache
    implements Comparable<LightCache> {
        final BlockCoord pos;
        final int color;
        final Cuboid6 cube;

        public LightCache(int x, int y, int z, int colorIndex, Cuboid6 cube) {
            this.pos = new BlockCoord(x, y, z);
            this.color = colorIndex;
            this.cube = cube;
        }

        @Override
        public int compareTo(LightCache o) {
            if (vec.set((double)this.pos.x, (double)this.pos.y, (double)this.pos.z).sub(renderEntityPos).magSquared() < vec.set((double)o.pos.x, (double)o.pos.y, (double)o.pos.z).sub(renderEntityPos).magSquared()) {
                return 1;
            }
            return -1;
        }
    }
}

