/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import mrtjp.projectred.ProjectRedIllumination;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.BasicWireUtils;
import mrtjp.projectred.illumination.ILight;
import mrtjp.projectred.illumination.RenderHalo;
import mrtjp.projectred.illumination.TileAirousLight;
import net.minecraftforge.common.ForgeDirection;

public abstract class BaseLightPart
extends JCuboidPart
implements TSlottedPart,
JNormalOcclusion,
IRedstonePart,
ILight {
    protected byte type;
    protected boolean isInverted;
    protected boolean powered;
    protected byte side;

    public void preparePlacement(int side, int meta, boolean inv) {
        this.isInverted = inv;
        this.side = (byte)side;
        this.type = (byte)meta;
    }

    public void writeDesc(MCDataOutput out) {
        out.writeByte((int)this.type);
        out.writeBoolean(this.isInverted);
        out.writeByte((int)this.side);
        out.writeBoolean(this.powered);
    }

    public void readDesc(MCDataInput in) {
        this.type = in.readByte();
        this.isInverted = in.readBoolean();
        this.side = in.readByte();
        this.powered = in.readBoolean();
    }

    public void save(by nbt) {
        nbt.a("inverted", this.isInverted);
        nbt.a("meta", this.type);
        nbt.a("rot", this.side);
        nbt.a("powered", this.powered);
    }

    public void load(by nbt) {
        this.isInverted = nbt.n("inverted");
        this.type = nbt.c("meta");
        this.side = nbt.a("rot") instanceof cf ? (byte)nbt.e("rot") : nbt.c("rot");
        this.powered = nbt.n("powered");
    }

    public void onNeighborChanged() {
        if (this.checkSupport()) {
            return;
        }
        this.updateState(false);
    }

    public void onPartChanged(TMultiPart t) {
        this.updateState(false);
    }

    public void onAdded() {
        this.updateState(true);
    }

    private boolean isBeingPowered() {
        return this.world().C(this.x(), this.y(), this.z());
    }

    public void updateState(boolean forceRender) {
        boolean updated = false;
        if (!this.world().I && this.powered != this.isBeingPowered()) {
            this.powered = !this.powered;
            this.updateRender();
            updated = true;
        }
        if (forceRender && !updated) {
            this.updateRender();
        }
    }

    public void updateRender() {
        this.world().j(this.x(), this.y(), this.z());
        this.world().A(this.x(), this.y(), this.z());
        if (!this.world().I) {
            this.sendDescUpdate();
        }
    }

    public boolean checkSupport() {
        if (BasicUtils.isClient((abw)this.world())) {
            return false;
        }
        BlockCoord bc = new BlockCoord(this.x(), this.y(), this.z()).offset((int)this.side);
        if (!(BasicWireUtils.canPlaceWireOnSide((abw)this.world(), (int)bc.x, (int)bc.y, (int)bc.z, (ForgeDirection)ForgeDirection.getOrientation((int)(this.side ^ 1)), (boolean)false) || BasicWireUtils.canPlaceTorchOnBlock((abw)this.world(), (int)bc.x, (int)bc.y, (int)bc.z, (boolean)false) && (this.side ^ 1) == 0)) {
            BasicUtils.dropItemFromLocation((abw)this.world(), (ye)this.getItem(), (boolean)false, null, (int)this.side, (int)10, (BlockCoord)new BlockCoord(this.x(), this.y(), this.z()));
            this.tile().remPart((TMultiPart)this);
            return true;
        }
        return false;
    }

    public boolean doesTick() {
        return this.isAirous();
    }

    public void update() {
        if (!this.world().I && this.isOn() && this.isAirous()) {
            int radius = 16;
            int x = this.x() + this.world().s.nextInt(radius) - this.world().s.nextInt(radius);
            int y = this.y() + this.world().s.nextInt(radius) - this.world().s.nextInt(radius);
            int z = this.z() + this.world().s.nextInt(radius) - this.world().s.nextInt(radius);
            if (y > this.world().f(x, z) + 4) {
                y = this.world().f(x, z) + 4;
            }
            if (y < 7) {
                y = 7;
            }
            if (this.world().c(x, y, z) && this.world().n(x, y, z) < 8) {
                this.world().f(x, y, z, ProjectRedIllumination.blockAirousLight.cF, this.getColor(), 3);
                TileAirousLight light = (TileAirousLight)this.world().r(x, y, z);
                if (light != null) {
                    light.setSource(new BlockCoord((asp)this.tile()), this.getColor(), this.side);
                }
            }
        }
    }

    public boolean isAirous() {
        return false;
    }

    public int getLightValue() {
        if (this.powered != this.isInverted) {
            return 15;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderStatic(Vector3 var1, LazyLightMatrix var2, int var3);

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0 && this.isOn()) {
            RenderHalo.addLight(this.x(), this.y(), this.z(), this.type, this.getLightBounds());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBreaking(bfr r) {
        RenderUtils.renderBlock((Cuboid6)this.getLightBounds(), (int)0, (Transformation)new Translation((double)this.x(), (double)this.y(), (double)this.z()), (IUVTransformation)new IconTransformation(r.d), null);
    }

    public abstract String getType();

    public abstract Cuboid6 getBounds();

    public abstract Cuboid6 getLightBounds();

    public abstract ye getItem();

    public int getSlotMask() {
        return 1 << this.side;
    }

    public float getStrength(ata hit, uf player) {
        return 2.0f;
    }

    public Iterable<ye> getDrops() {
        return Arrays.asList(this.getItem());
    }

    public ye pickItem(ata hit) {
        return this.getItem();
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(this.getBounds());
    }

    public boolean canConnectRedstone(int arg0) {
        return true;
    }

    public int strongPowerLevel(int arg0) {
        return 0;
    }

    public int weakPowerLevel(int arg0) {
        return 0;
    }

    @Override
    public boolean isOn() {
        return this.getLightValue() == 15;
    }

    @Override
    public int getColor() {
        return this.type;
    }
}

