/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.render;

import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openmods.block.OpenBlock;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static void setupBillboard(Entity rve) {
        GL11.glRotatef((float)(-rve.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rve.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public static World getRenderWorld() {
        if (Minecraft.func_71410_x() != null) {
            return Minecraft.func_71410_x().field_71441_e;
        }
        return null;
    }

    public static double interpolateValue(double current, double prev, float partialTickTime) {
        return prev + (double)partialTickTime * (current - prev);
    }

    public static float interpolateYaw(Entity e, float f) {
        return e.field_70126_B + (e.field_70177_z - e.field_70126_B) * f;
    }

    public static float interpolatePitch(Entity e, float f) {
        return e.field_70127_C + (e.field_70125_A - e.field_70127_C) * f;
    }

    public static void translateToPlayer(Entity e, float partialTickTime) {
        GL11.glTranslated((double)(RenderUtils.interpolateValue(e.field_70165_t, e.field_70169_q, partialTickTime) - RenderManager.field_78725_b), (double)(RenderUtils.interpolateValue(e.field_70163_u, e.field_70167_r, partialTickTime) - RenderManager.field_78726_c), (double)(RenderUtils.interpolateValue(e.field_70161_v, e.field_70166_s, partialTickTime) - RenderManager.field_78723_d));
    }

    public static void translateToWorld(Entity e, float partialTickTime) {
        GL11.glTranslated((double)RenderUtils.interpolateValue(e.field_70165_t, e.field_70169_q, partialTickTime), (double)RenderUtils.interpolateValue(e.field_70163_u, e.field_70167_r, partialTickTime), (double)RenderUtils.interpolateValue(e.field_70161_v, e.field_70166_s, partialTickTime));
    }

    public static void rotateFacesOnRenderer(OpenBlock block, ForgeDirection rotation, RenderBlocks renderer) {
        OpenBlock.BlockRotationMode mode = block.getRotationMode();
        block0 : switch (mode) {
            case SIX_DIRECTIONS: {
                switch (rotation) {
                    case DOWN: {
                        renderer.field_78685_i = 3;
                        renderer.field_78679_j = 3;
                        renderer.field_78662_g = 3;
                        renderer.field_78683_h = 3;
                        break block0;
                    }
                    case EAST: {
                        renderer.field_78681_k = 1;
                        renderer.field_78675_l = 2;
                        renderer.field_78683_h = 1;
                        renderer.field_78662_g = 2;
                        break block0;
                    }
                    case NORTH: {
                        renderer.field_78679_j = 2;
                        renderer.field_78685_i = 1;
                        break block0;
                    }
                    case SOUTH: {
                        renderer.field_78681_k = 3;
                        renderer.field_78675_l = 3;
                        renderer.field_78679_j = 1;
                        renderer.field_78685_i = 2;
                        break block0;
                    }
                    case UNKNOWN: {
                        break block0;
                    }
                    case UP: {
                        break block0;
                    }
                    case WEST: {
                        renderer.field_78681_k = 2;
                        renderer.field_78675_l = 1;
                        renderer.field_78683_h = 2;
                        renderer.field_78662_g = 1;
                        break block0;
                    }
                }
                break;
            }
            case FOUR_DIRECTIONS: {
                switch (rotation) {
                    case EAST: {
                        renderer.field_78681_k = 1;
                        break block0;
                    }
                    case WEST: {
                        renderer.field_78681_k = 2;
                        break block0;
                    }
                    case SOUTH: {
                        renderer.field_78681_k = 3;
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public static void resetFacesOnRenderer(RenderBlocks renderer) {
        renderer.field_78681_k = 0;
        renderer.field_78675_l = 0;
        renderer.field_78662_g = 0;
        renderer.field_78679_j = 0;
        renderer.field_78685_i = 0;
        renderer.field_78681_k = 0;
        renderer.field_78683_h = 0;
        renderer.field_78666_e = false;
    }

    public static void renderInventoryBlock(RenderBlocks renderer, Block block, ForgeDirection rotation) {
        RenderUtils.renderInventoryBlock(renderer, block, rotation, -1);
    }

    public static void renderInventoryBlock(RenderBlocks renderer, Block block, ForgeDirection rotation, int colorMultiplier) {
        RenderUtils.renderInventoryBlock(renderer, block, rotation, colorMultiplier, null);
    }

    public static void renderInventoryBlock(RenderBlocks renderer, Block block, ForgeDirection rotation, int colorMultiplier, Set<ForgeDirection> enabledSides) {
        Tessellator tessellator = Tessellator.field_78398_a;
        block.func_71919_f();
        renderer.func_83018_a(block);
        if (colorMultiplier > -1) {
            float r = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f;
            float g = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f;
            float b = (float)(colorMultiplier & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        int metadata = rotation.ordinal();
        if (enabledSides == null || enabledSides.contains(ForgeDirection.DOWN)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderer.func_78613_a(block, 0.0, 0.0, 0.0, renderer.func_94165_a(block, 0, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides == null || enabledSides.contains(ForgeDirection.UP)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderer.func_78617_b(block, 0.0, 0.0, 0.0, renderer.func_94165_a(block, 1, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides == null || enabledSides.contains(ForgeDirection.SOUTH)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderer.func_78611_c(block, 0.0, 0.0, 0.0, renderer.func_94165_a(block, 2, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides == null || enabledSides.contains(ForgeDirection.NORTH)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderer.func_78622_d(block, 0.0, 0.0, 0.0, renderer.func_94165_a(block, 3, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides == null || enabledSides.contains(ForgeDirection.WEST)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderer.func_78573_e(block, 0.0, 0.0, 0.0, renderer.func_94165_a(block, 4, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides == null || enabledSides.contains(ForgeDirection.EAST)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderer.func_78605_f(block, 0.0, 0.0, 0.0, renderer.func_94165_a(block, 5, metadata));
            tessellator.func_78381_a();
        }
        GL11.glPopMatrix();
    }

    public static void disableLightmap() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static void reenableLightmap() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }
}

