/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.common.ForgeDirection;
import openmods.utils.MathUtils;

public class OpenModsFakePlayer
extends FakePlayer {
    private static final HashMap<Integer, OpenModsFakePlayer> _players = new HashMap();

    public static OpenModsFakePlayer getPlayerForWorld(World world) {
        int id = world.field_73011_w.field_76574_g;
        if (!_players.containsKey(id)) {
            _players.put(id, new OpenModsFakePlayer(world));
        }
        return _players.get(id);
    }

    private OpenModsFakePlayer(World world) {
        super(world, "OpenModsFakePlayer");
    }

    public void func_70106_y() {
        _players.remove(this.field_70170_p.field_73011_w.field_76574_g);
        super.func_70106_y();
    }

    public ItemStack equipWithAndRightClick(ItemStack itemStack, Vec3 currentPos, Vec3 hitVector, ForgeDirection side, boolean blockExists) {
        float deltaZ;
        float deltaY;
        float deltaX;
        this.func_70107_b(currentPos.field_72450_a, currentPos.field_72448_b, currentPos.field_72449_c);
        ForgeDirection opposite = side.getOpposite();
        if (blockExists) {
            deltaX = (float)(currentPos.field_72450_a - hitVector.field_72450_a);
            deltaY = (float)(currentPos.field_72448_b - hitVector.field_72448_b);
            deltaZ = (float)(currentPos.field_72449_c - hitVector.field_72449_c);
            this.func_70095_a(false);
            if (this.rightClick(this.field_71071_by.func_70448_g(), (int)currentPos.field_72450_a + opposite.offsetX, (int)currentPos.field_72448_b + opposite.offsetY, (int)currentPos.field_72449_c + opposite.offsetZ, opposite.ordinal(), deltaX, deltaY, deltaZ, blockExists)) {
                this.func_70095_a(true);
                return this.field_71071_by.func_70448_g();
            }
            hitVector.field_72448_b += 1.0;
            this.func_70095_a(true);
        }
        deltaX = (float)(currentPos.field_72450_a - hitVector.field_72450_a);
        deltaY = (float)(currentPos.field_72448_b - hitVector.field_72448_b);
        deltaZ = (float)(currentPos.field_72449_c - hitVector.field_72449_c);
        float distanceInGroundPlain = (float)Math.sqrt((float)MathUtils.lengthSq(deltaX, deltaZ));
        float pitch = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI);
        float hue = (float)(Math.atan2(deltaY, distanceInGroundPlain) * 180.0 / Math.PI);
        this.func_70101_b(pitch, hue);
        this.field_71071_by.func_82347_b(-1, -1);
        this.field_71071_by.func_70441_a(itemStack);
        this.rightClick(this.field_71071_by.func_70448_g(), (int)currentPos.field_72450_a + opposite.offsetX, (int)currentPos.field_72448_b + opposite.offsetY, (int)currentPos.field_72449_c + opposite.offsetZ, opposite.ordinal(), deltaX, deltaY, deltaZ, blockExists);
        return ItemStack.func_77944_b((ItemStack)itemStack);
    }

    public void dropItemAt(ItemStack itemStack, int x, int y, int z, ForgeDirection direction) {
        this.func_70107_b((float)x + 0.5f, (double)y - 1.5, (float)z + 0.5f);
        if (direction != ForgeDirection.DOWN) {
            throw new IllegalStateException();
        }
        this.func_70101_b(0.0f, 90.0f);
        EntityItem entityItem = this.func_71021_b(itemStack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.0;
        entityItem.field_70179_y = 0.0;
    }

    private boolean rightClick(ItemStack itemStack, int x, int y, int z, int side, float deltaX, float deltaY, float deltaZ, boolean blockExists) {
        int blockId;
        boolean flag = false;
        if (itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b().onItemUseFirst(itemStack, (EntityPlayer)this, this.field_70170_p, x, y, z, side, deltaX, deltaY, deltaZ)) {
            return true;
        }
        if ((this.func_70093_af() || this.func_70694_bm() == null || this.func_70694_bm().func_77973_b().shouldPassSneakingClickToBlock(this.field_70170_p, x, y, z)) && (blockId = this.field_70170_p.func_72798_a(x, y, z)) > 0 && Block.field_71973_m[blockId].func_71903_a(this.field_70170_p, x, y, z, (EntityPlayer)this, side, deltaX, deltaY, deltaZ)) {
            flag = true;
        }
        if (!flag && itemStack != null && itemStack.func_77973_b() instanceof ItemBlock) {
            if (blockExists) {
                return false;
            }
            ItemBlock itemblock = (ItemBlock)itemStack.func_77973_b();
            if (!this.canPlaceItemBlockOnSide(itemblock, this.field_70170_p, x, y, z, side, itemStack)) {
                return false;
            }
        }
        if (flag) {
            return true;
        }
        if (itemStack == null) {
            return false;
        }
        ForgeDirection s = ForgeDirection.getOrientation((int)side);
        return itemStack.func_77943_a((EntityPlayer)this, this.field_70170_p, x + s.offsetX, y + s.offsetY, z + s.offsetZ, s.getOpposite().ordinal(), deltaX, deltaY, deltaZ);
    }

    private boolean canPlaceItemBlockOnSide(ItemBlock itemBlock, World world, int x, int y, int z, int side, ItemStack itemStack) {
        int blockId = world.func_72798_a(x, y, z);
        if (blockId == Block.field_72037_aS.field_71990_ca) {
            side = 1;
        } else if (blockId == Block.field_71998_bu.field_71990_ca || blockId == Block.field_71962_X.field_71990_ca || blockId == Block.field_71961_Y.field_71990_ca || Block.field_71973_m[blockId] == null || !Block.field_71973_m[blockId].isBlockReplaceable(world, x, y, z)) {
            // empty if block
        }
        int oppositeSide = ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
        return world.func_72931_a(itemBlock.func_77883_f(), x, y, z, false, oppositeSide, (Entity)this, itemStack);
    }
}

