/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ColorUtils {
    public static final int BLACK = 0;
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int BROWN = 3;
    public static final int BLUE = 4;
    public static final int PURPLE = 5;
    public static final int CYAN = 6;
    public static final int LIGHT_GRAY = 7;
    public static final int GRAY = 8;
    public static final int PINK = 9;
    public static final int LIME = 10;
    public static final int YELLOW = 11;
    public static final int LIGHT_BLUE = 12;
    public static final int MAGENTA = 13;
    public static final int ORANGE = 14;
    public static final int WHITE = 15;
    private static final List<ColorMeta> COLORS = Lists.newArrayList();
    private static final Map<String, ColorMeta> COLORS_BY_ORE_NAME = Maps.newHashMap();
    private static final Map<Integer, ColorMeta> COLORS_BY_ORE_ID = Maps.newHashMap();

    public static ItemStack createDyedWool(int color) {
        return ColorUtils.createDyedBlock(Block.field_72101_ab, color);
    }

    public static ItemStack createStainedClay(int color) {
        return ColorUtils.createDyedBlock(Block.field_111039_cA, color);
    }

    public static ItemStack createDyedCarpet(int color) {
        return ColorUtils.createDyedBlock(Block.field_111031_cC, color);
    }

    public static ItemStack createDyedBlock(Block block, int color) {
        int blockColor = BlockColored.func_72238_e_((int)color);
        return new ItemStack(block, 1, blockColor);
    }

    private static void addEntry(String oreName, int colorValue, int vanillaId) {
        int oreId = OreDictionary.getOreID((String)oreName);
        ColorMeta color = new ColorMeta(colorValue, vanillaId, oreId, oreName);
        COLORS.add(color);
        COLORS_BY_ORE_NAME.put(oreName, color);
        COLORS_BY_ORE_ID.put(oreId, color);
    }

    public static ColorMeta stackToColor(ItemStack stack) {
        int oreId = OreDictionary.getOreID((ItemStack)stack);
        if (oreId < 0) {
            return null;
        }
        return COLORS_BY_ORE_ID.get(oreId);
    }

    public static ColorMeta oreIdToColor(int oreId) {
        return COLORS_BY_ORE_ID.get(oreId);
    }

    public static ColorMeta oreNameToColor(String oreName) {
        return COLORS_BY_ORE_NAME.get(oreName);
    }

    public static Collection<ColorMeta> getAllColors() {
        return Collections.unmodifiableCollection(COLORS);
    }

    static {
        ColorUtils.addEntry("dyeBlack", 0x1E1B1B, 0);
        ColorUtils.addEntry("dyeRed", 11743532, 1);
        ColorUtils.addEntry("dyeGreen", 3887386, 2);
        ColorUtils.addEntry("dyeBrown", 5320730, 3);
        ColorUtils.addEntry("dyeBlue", 2437522, 4);
        ColorUtils.addEntry("dyePurple", 8073150, 5);
        ColorUtils.addEntry("dyeCyan", 2651799, 6);
        ColorUtils.addEntry("dyeLightGray", 0xABABAB, 7);
        ColorUtils.addEntry("dyeGray", 0x434343, 8);
        ColorUtils.addEntry("dyePink", 14188952, 9);
        ColorUtils.addEntry("dyeLime", 4312372, 10);
        ColorUtils.addEntry("dyeYellow", 14602026, 11);
        ColorUtils.addEntry("dyeLightBlue", 6719955, 12);
        ColorUtils.addEntry("dyeMagenta", 12801229, 13);
        ColorUtils.addEntry("dyeOrange", 15435844, 14);
        ColorUtils.addEntry("dyeWhite", 0xF0F0F0, 15);
    }

    public static class CYMK {
        private float cyan;
        private float yellow;
        private float magenta;
        private float key;

        public CYMK(float c, float y, float m, float k) {
            this.cyan = c;
            this.yellow = y;
            this.magenta = m;
            this.key = k;
        }

        public float getCyan() {
            return this.cyan;
        }

        public void setCyan(float cyan) {
            this.cyan = cyan;
        }

        public float getYellow() {
            return this.yellow;
        }

        public void setYellow(float yellow) {
            this.yellow = yellow;
        }

        public float getMagenta() {
            return this.magenta;
        }

        public void setMagenta(float magenta) {
            this.magenta = magenta;
        }

        public float getKey() {
            return this.key;
        }

        public void setKey(float key) {
            this.key = key;
        }
    }

    public static class RGB {
        private int r;
        private int g;
        private int b;

        public RGB(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public RGB(int color) {
            this((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF);
        }

        public RGB() {
            this(0);
        }

        public int getR() {
            return this.r;
        }

        public void setR(int r) {
            this.r = r;
        }

        public int getG() {
            return this.g;
        }

        public void setG(int g) {
            this.g = g;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        public void setColor(int r, int g, int b) {
            this.setR(r);
            this.setG(g);
            this.setB(b);
        }

        public void setColor(int color) {
            this.setColor((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF);
        }

        public int getColor() {
            return this.r << 16 | this.g << 8 | this.b;
        }

        public RGB interpolate(RGB other, double amount) {
            int iPolR = (int)((double)this.r * (1.0 - amount) + (double)other.r * amount);
            int iPolG = (int)((double)this.g * (1.0 - amount) + (double)other.g * amount);
            int iPolB = (int)((double)this.b * (1.0 - amount) + (double)other.b * amount);
            return new RGB(iPolR, iPolG, iPolB);
        }

        public CYMK toCYMK() {
            float cyan = 1.0f - (float)this.r / 255.0f;
            float magenta = 1.0f - (float)this.g / 255.0f;
            float yellow = 1.0f - (float)this.b / 255.0f;
            float K = 1.0f;
            if (cyan < K) {
                K = cyan;
            }
            if (magenta < K) {
                K = magenta;
            }
            if (yellow < K) {
                K = yellow;
            }
            if (K == 1.0f) {
                cyan = 0.0f;
                magenta = 0.0f;
                yellow = 0.0f;
            } else {
                cyan = (cyan - K) / (1.0f - K);
                magenta = (magenta - K) / (1.0f - K);
                yellow = (yellow - K) / (1.0f - K);
            }
            return new CYMK(cyan, yellow, magenta, K);
        }
    }

    public static class ColorMeta {
        public final int rgb;
        public final int vanillaId;
        public final int oreId;
        public final String oreName;

        public ColorMeta(int rgb, int vanillaId, int oreId, String oreName) {
            this.rgb = rgb;
            this.vanillaId = vanillaId;
            this.oreId = oreId;
            this.oreName = oreName;
        }
    }
}

