/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import openmods.OpenMods;
import openmods.liquids.GenericTank;
import openmods.sync.ISyncableObject;

public class SyncableTank
extends GenericTank
implements ISyncableObject {
    private boolean dirty = false;
    private long ticksSinceChange = 0L;

    public SyncableTank(int capacity, FluidStack ... acceptableFluids) {
        super(capacity, acceptableFluids);
    }

    @Override
    public int getTicksSinceChange(World world) {
        return (int)(OpenMods.proxy.getTicks(world) - this.ticksSinceChange);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void markClean() {
        this.dirty = false;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void readFromStream(DataInput stream) throws IOException {
        int fluidId = stream.readInt();
        if (fluidId > -1) {
            int fluidAmount = stream.readInt();
            short len = stream.readShort();
            NBTTagCompound tag = null;
            if (len > 0) {
                byte[] bytes = new byte[len];
                stream.readFully(bytes);
                tag = CompressedStreamTools.func_74792_a((byte[])bytes);
            }
            this.fluid = new FluidStack(fluidId, fluidAmount, tag);
        } else {
            this.fluid = null;
        }
    }

    @Override
    public void writeToStream(DataOutput stream, boolean fullData) throws IOException {
        if (this.fluid != null) {
            stream.writeInt(this.fluid.fluidID);
            stream.writeInt(this.fluid.amount);
            if (this.fluid.tag == null) {
                stream.writeShort(-1);
            } else {
                byte[] bytes = CompressedStreamTools.func_74798_a((NBTTagCompound)this.fluid.tag);
                stream.writeShort(bytes.length);
                stream.write(bytes);
            }
        } else {
            stream.writeInt(-1);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        this.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        this.readFromNBT(tag);
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        int filled = super.fill(resource, doFill);
        if (filled > 0) {
            this.markDirty();
        }
        return filled;
    }

    @Override
    public FluidStack drain(FluidStack stack, boolean doDrain) {
        FluidStack drained = super.drain(stack, doDrain);
        if (drained != null) {
            this.markDirty();
        }
        return drained;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = super.drain(maxDrain, doDrain);
        if (drained != null) {
            this.markDirty();
        }
        return drained;
    }

    @Override
    public void resetChangeTimer(World world) {
        this.ticksSinceChange = OpenMods.proxy.getTicks(world);
    }
}

