/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import net.minecraft.client.Minecraft;
import openmods.gui.component.BaseComponent;
import openmods.sync.SyncableInt;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiComponentSlider
extends BaseComponent {
    private static final int HANDLE_SIZE = 8;
    private int width;
    private int min;
    private int max;
    private SyncableInt value;
    private double stepSize;
    private int steps;
    private boolean isDragging = false;
    private int startDragX;
    private boolean showValue = true;

    public GuiComponentSlider(int x, int y, int width, int min, int max, SyncableInt val, boolean showValue) {
        this(x, y, width, min, max, val);
        this.showValue = showValue;
    }

    public GuiComponentSlider(int x, int y, int width, int min, int max, SyncableInt val) {
        super(x, y);
        this.width = width;
        this.min = min;
        this.max = max;
        this.steps = max - min;
        this.value = val;
        this.stepSize = (double)(width - 8 - 2) / (double)this.steps;
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.render(minecraft, offsetX, offsetY, mouseX, mouseY);
        int level = this.value.getValue();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = offsetX + this.x;
        int top = offsetY + this.y;
        int barStartX = left + 1;
        this.bindComponentsSheet();
        this.func_73729_b(left, top, 0, 70, 1, this.getHeight());
        GL11.glPushMatrix();
        GL11.glTranslated((double)(left + 1), (double)top, (double)0.0);
        GL11.glScaled((double)(this.getWidth() - 2), (double)1.0, (double)1.0);
        this.func_73729_b(0, 0, 1, 70, 1, this.getHeight());
        GL11.glPopMatrix();
        this.func_73729_b(left + this.getWidth() - 1, top, 2, 70, 1, this.getHeight());
        int handleX = (int)Math.floor((double)barStartX + this.stepSize * (double)(level - this.min));
        if (Mouse.isButtonDown((int)0)) {
            if (!this.isDragging && mouseX + offsetX > handleX && mouseX + offsetX < handleX + 8 && mouseY > this.y && mouseY < this.y + this.getHeight()) {
                this.isDragging = true;
                this.startDragX = mouseX - handleX;
            }
        } else if (this.isDragging) {
            this.isDragging = false;
            this.onMouseUp();
        }
        if (this.isDragging) {
            int offX = mouseX - barStartX - this.startDragX;
            level = this.min + (int)Math.round((double)offX / this.stepSize);
        }
        level = Math.max(this.min, Math.min(this.max, level));
        this.func_73729_b(handleX, top + 1, 3, 70, 9, 10);
        if (this.showValue) {
            String label = Integer.toString(level);
            int strWidth = minecraft.field_71466_p.func_78256_a(label);
            minecraft.field_71466_p.func_78276_b(label, handleX + 4 - strWidth / 2, top + 15, 0x404040);
        }
        this.value.setValue(level);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return 12;
    }

    public void onMouseUp() {
    }
}

