/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.util.StatCollector;
import openmods.container.ContainerBase;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentPanel;
import openmods.tileentity.SyncedTileEntity;
import org.lwjgl.opengl.GL11;

public abstract class BaseGuiContainer<T extends ContainerBase<?>>
extends GuiContainer {
    protected BaseComponent root;
    protected String name;

    public BaseGuiContainer(T container, int width, int height, String name) {
        super(container);
        this.field_74194_b = width;
        this.field_74195_c = height;
        this.root = this.createRoot();
        this.name = name;
    }

    protected BaseComponent createRoot() {
        return new GuiComponentPanel(0, 0, this.field_74194_b, this.field_74195_c, (Container)this.getContainer());
    }

    public T getContainer() {
        return (T)((Object)((ContainerBase)this.field_74193_d));
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.root.mouseClicked(x - this.field_74198_m, y - this.field_74197_n, button);
        this.syncChangesToServer();
    }

    protected void func_73879_b(int x, int y, int button) {
        super.func_73879_b(x, y, button);
        this.root.mouseMovedOrUp(x - this.field_74198_m, y - this.field_74197_n, button);
        this.syncChangesToServer();
    }

    protected void func_85041_a(int mouseX, int mouseY, int button, long time) {
        super.func_85041_a(mouseX, mouseY, button, time);
        this.root.mouseClickMove(mouseX - this.field_74198_m, mouseY - this.field_74197_n, button, time);
    }

    private void syncChangesToServer() {
        Object te = ((ContainerBase)((Object)this.getContainer())).getOwner();
        if (te instanceof SyncedTileEntity) {
            ((SyncedTileEntity)te).sync();
        }
    }

    public void preRender(float mouseX, float mouseY) {
        this.root.mouseMovedOrUp((int)mouseX - this.field_74198_m, (int)mouseY - this.field_74197_n, -1);
    }

    protected void func_73869_a(char par1, int par2) {
        super.func_73869_a(par1, par2);
        this.root.keyTyped(par1, par2);
    }

    public void postRender(int mouseX, int mouseY) {
    }

    protected void func_74185_a(float f, int mouseX, int mouseY) {
        this.preRender(mouseX, mouseY);
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.field_74198_m, (double)this.field_74197_n, (double)0.0);
        BaseComponent.IS_OVERLAY_PASS = false;
        this.root.render(this.field_73882_e, 0, 0, mouseX - this.field_74198_m, mouseY - this.field_74197_n);
        GL11.glPopMatrix();
    }

    protected void func_74189_g(int mouseX, int mouseY) {
        this.postRender(mouseX, mouseY);
        String machineName = StatCollector.func_74838_a((String)this.name);
        int x = this.field_74194_b / 2 - this.field_73886_k.func_78256_a(machineName) / 2;
        this.field_73886_k.func_78276_b(machineName, x, 6, 0x404040);
        String translatedName = StatCollector.func_74838_a((String)"container.inventory");
        this.field_73886_k.func_78276_b(translatedName, 8, this.field_74195_c - 96 + 2, 0x404040);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        BaseComponent.IS_OVERLAY_PASS = true;
        this.root.render(this.field_73882_e, this.field_74198_m, this.field_74197_n, par1 - this.field_74198_m, par2 - this.field_74197_n);
        GL11.glPopMatrix();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
    }

    public void sendButtonClick(int buttonId) {
        this.field_73882_e.field_71442_b.func_78756_a(((ContainerBase)((Object)this.getContainer())).field_75152_c, buttonId);
    }
}

