/*
 * Decompiled with CFR 0.152.
 */
package openmods.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import openmods.Log;
import openmods.config.BlockId;
import openmods.config.ConfigProperty;
import openmods.config.IRegisterableBlock;
import openmods.config.ItemId;
import openmods.config.RegisterBlock;
import openmods.config.RegisterFluid;
import openmods.config.RegisterItem;
import openmods.utils.io.IStringSerializable;
import openmods.utils.io.StringConversionException;
import openmods.utils.io.TypeRW;

public class ConfigProcessing {
    public static final Map<Class<?>, Property.Type> CONFIG_TYPES = ImmutableMap.builder().put(Integer.class, (Object)Property.Type.INTEGER).put(Boolean.class, (Object)Property.Type.BOOLEAN).put(Byte.class, (Object)Property.Type.INTEGER).put(Double.class, (Object)Property.Type.DOUBLE).put(Float.class, (Object)Property.Type.DOUBLE).put(Long.class, (Object)Property.Type.INTEGER).put(Short.class, (Object)Property.Type.INTEGER).put(String.class, (Object)Property.Type.STRING).build();

    private static void getProperty(Configuration configFile, Field f, String category, String name, String comment) {
        Object defaultValue;
        if (Strings.isNullOrEmpty((String)name)) {
            name = f.getName();
        }
        if (Strings.isNullOrEmpty((String)category)) {
            category = null;
        }
        try {
            defaultValue = f.get(null);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        Preconditions.checkNotNull((Object)defaultValue, (String)"Config field %s has no default value", (Object[])new Object[]{name});
        Class<?> fieldType = defaultValue.getClass();
        Property.Type expectedType = CONFIG_TYPES.get(fieldType);
        Preconditions.checkNotNull((Object)expectedType, (String)"Config field %s has no property type mapping", (Object[])new Object[]{name});
        IStringSerializable converter = TypeRW.TYPES.get(fieldType);
        Preconditions.checkNotNull((Object)converter, (String)"Config field %s has no known conversion from string", (Object[])new Object[]{name});
        String defaultString = defaultValue.toString();
        Property property = configFile.get(category, name, defaultString, comment, expectedType);
        if (property.hasChanged()) {
            return;
        }
        String valueString = property.getString();
        Property.Type actualType = property.getType();
        if (expectedType != actualType) {
            Log.warn("Invalid config property type '%s', using default value '%s' of type '%s'", property.getType(), defaultString, expectedType);
        } else if (!valueString.equals(defaultString)) {
            try {
                Object value = converter.readFromString(valueString);
                try {
                    f.set(null, value);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            catch (StringConversionException e) {
                Log.warn(e, "Invalid config property value '%s', using default '%s'", valueString, defaultString);
                property.set(defaultString);
            }
        }
    }

    private static void getBlock(Configuration configFile, Field field, String description) {
        try {
            int defaultValue = field.getInt(null);
            Property prop = configFile.getBlock("block", field.getName(), defaultValue, description);
            field.set(null, prop.getInt());
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void getItem(Configuration configFile, Field field, String description) {
        try {
            int defaultValue = field.getInt(null);
            Property prop = configFile.getItem("item", field.getName(), defaultValue, description);
            field.set(null, prop.getInt());
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static boolean canRegisterBlock(int blockId) {
        if (blockId > 0) {
            Preconditions.checkState((Block.field_71973_m[blockId] == null ? 1 : 0) != 0, (String)"OpenBlocks tried to register a block for ID: %s but it was in use", (Object[])new Object[]{blockId});
            return true;
        }
        return false;
    }

    public static void processAnnotations(Configuration configFile, Class<?> klazz) {
        for (Field f : klazz.getFields()) {
            Annotation a = f.getAnnotation(ItemId.class);
            if (a != null) {
                ConfigProcessing.getItem(configFile, f, a.description());
                continue;
            }
            a = f.getAnnotation(BlockId.class);
            if (a != null) {
                ConfigProcessing.getBlock(configFile, f, a.description());
            }
            if ((a = f.getAnnotation(ConfigProperty.class)) == null) continue;
            ConfigProcessing.getProperty(configFile, f, a.category(), a.name(), a.comment());
        }
    }

    public static <I, A extends Annotation> void processAnnotations(Class<?> config, Class<I> fieldClass, Class<A> annotationClass, IAnnotationProcessor<I, A> processor) {
        for (Field f : config.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !fieldClass.isAssignableFrom(f.getType())) continue;
            A annotation = f.getAnnotation(annotationClass);
            if (annotation != null) {
                try {
                    Object entry = f.get(null);
                    if (entry == null) continue;
                    processor.process(entry, annotation);
                    continue;
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            Log.warn("Field %s has valid type %s for registration, but no annotation %s", f, fieldClass, annotationClass);
        }
    }

    private static String dotName(String a, String b) {
        return a + "." + b;
    }

    private static String underscoreName(String a, String b) {
        return a + "_" + b;
    }

    public static void registerItems(Class<?> klazz, final String mod) {
        ConfigProcessing.processAnnotations(klazz, Item.class, RegisterItem.class, new IAnnotationProcessor<Item, RegisterItem>(){

            @Override
            public void process(Item item, RegisterItem annotation) {
                String name = ConfigProcessing.dotName(mod, annotation.name());
                GameRegistry.registerItem((Item)item, (String)name);
                String unlocalizedName = annotation.unlocalizedName();
                if (!unlocalizedName.equals("[none]")) {
                    unlocalizedName = unlocalizedName.equals("[default]") ? name : ConfigProcessing.dotName(mod, unlocalizedName);
                    item.func_77655_b(unlocalizedName);
                }
            }
        });
    }

    public static void registerBlocks(Class<?> klazz, final String mod) {
        ConfigProcessing.processAnnotations(klazz, Block.class, RegisterBlock.class, new IAnnotationProcessor<Block, RegisterBlock>(){

            @Override
            public void process(Block block, RegisterBlock annotation) {
                String name = annotation.name();
                Class<? extends ItemBlock> itemBlock = annotation.itemBlock();
                Class<? extends TileEntity> teClass = annotation.tileEntity();
                if (teClass == TileEntity.class) {
                    teClass = null;
                }
                String blockName = ConfigProcessing.underscoreName(mod, name);
                GameRegistry.registerBlock((Block)block, itemBlock, (String)blockName);
                String unlocalizedName = annotation.unlocalizedName();
                if (!unlocalizedName.equals("[none]")) {
                    unlocalizedName = unlocalizedName.equals("[default]") ? ConfigProcessing.dotName(mod, name) : ConfigProcessing.dotName(mod, unlocalizedName);
                    block.func_71864_b(unlocalizedName);
                }
                if (teClass != null) {
                    GameRegistry.registerTileEntity(teClass, (String)blockName);
                }
                if (block instanceof IRegisterableBlock) {
                    ((IRegisterableBlock)block).setupBlock(mod, name, teClass, itemBlock);
                }
                for (RegisterBlock.RegisterTileEntity te : annotation.tileEntities()) {
                    String teName = ConfigProcessing.underscoreName(mod, te.name());
                    GameRegistry.registerTileEntity(te.cls(), (String)teName);
                }
            }
        });
    }

    public static void registerFluids(Class<?> klazz, final String mod) {
        ConfigProcessing.processAnnotations(klazz, Fluid.class, RegisterFluid.class, new IAnnotationProcessor<Fluid, RegisterFluid>(){

            @Override
            public void process(Fluid fluid, RegisterFluid annotation) {
                fluid.setDensity(annotation.density());
                fluid.setGaseous(annotation.gaseous());
                fluid.setLuminosity(annotation.luminosity());
                fluid.setViscosity(annotation.viscosity());
                FluidRegistry.registerFluid((Fluid)fluid);
                fluid.setUnlocalizedName(String.format("%s.%s", mod, annotation.name()));
            }
        });
    }

    private static interface IAnnotationProcessor<I, A extends Annotation> {
        public void process(I var1, A var2);
    }
}

