/*
 * Decompiled with CFR 0.152.
 */
package openmods.binding;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.client.settings.KeyBinding;
import openmods.binding.ActionBind;
import openmods.binding.KeyDispatcher;

public class KeyDispatcherBuilder {
    private final List<ActionBind> bindings = Lists.newArrayList();

    public KeyDispatcherBuilder addBinding(ActionBind binding) {
        this.bindings.add(binding);
        return this;
    }

    public KeyDispatcher build() {
        IdentityHashMap bindingMap = Maps.newIdentityHashMap();
        KeyBinding[] bindingsArray = new KeyBinding[this.bindings.size()];
        boolean[] repeatings = new boolean[this.bindings.size()];
        for (int i = 0; i < this.bindings.size(); ++i) {
            ActionBind action = this.bindings.get(i);
            KeyBinding binding = action.createBinding();
            bindingMap.put(binding, action);
            bindingsArray[i] = binding;
            repeatings[i] = action.isRepeatable();
        }
        return new KeyDispatcher(bindingsArray, repeatings, bindingMap);
    }
}

