/*
 * Decompiled with CFR 0.152.
 */
package openmods.asm;

import com.google.common.base.Preconditions;
import net.minecraft.launchwrapper.IClassTransformer;
import openmods.asm.IncludingClassVisitor;
import openmods.asm.StopTransforming;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class OpenModsClassTransformer
implements IClassTransformer {
    private static final TransformProvider INCLUDING_CV = new TransformProvider(){

        @Override
        public ClassVisitor createVisitor(ClassVisitor cv) {
            return new IncludingClassVisitor(cv);
        }
    };

    public static byte[] applyVisitor(byte[] bytes, int flags, TransformProvider context) {
        Preconditions.checkNotNull((Object)bytes);
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(cr, flags);
        ClassVisitor mod = context.createVisitor((ClassVisitor)cw);
        try {
            cr.accept(mod, 0);
            return cw.toByteArray();
        }
        catch (StopTransforming e) {
            return bytes;
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null || name.startsWith("openmods.asm") || name.startsWith("net.minecraft.")) {
            return bytes;
        }
        return OpenModsClassTransformer.applyVisitor(bytes, 0, INCLUDING_CV);
    }

    public static interface TransformProvider {
        public ClassVisitor createVisitor(ClassVisitor var1);
    }
}

