/*
 * Decompiled with CFR 0.152.
 */
package openmods;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import openmods.LibConfig;
import openmods.Log;
import openmods.config.ConfigProcessing;
import openmods.entity.DelayedEntityLoadManager;
import openmods.integration.Integration;
import openmods.network.EventPacket;
import openmods.network.PacketHandler;
import openmods.network.events.TileEntityEventHandler;
import openmods.proxy.IOpenModsProxy;
import openmods.sync.SyncableManager;

@Mod(modid="OpenMods", name="OpenMods", version="0.1", dependencies="required-after:OpenModsCore")
@NetworkMod(serverSideRequired=true, clientSideRequired=false, channels={"OpenMods|S", "OpenMods|E"}, packetHandler=PacketHandler.class)
public class OpenMods {
    @Mod.Instance(value="OpenMods")
    public static OpenMods instance;
    @SidedProxy(clientSide="openmods.proxy.OpenClientProxy", serverSide="openmods.proxy.OpenServerProxy")
    public static IOpenModsProxy proxy;
    public static SyncableManager syncableManager;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        Log.logger = evt.getModLog();
        EventPacket.registerCorePackets();
        Configuration configFile = new Configuration(evt.getSuggestedConfigurationFile());
        ConfigProcessing.processAnnotations(configFile, LibConfig.class);
        if (configFile.hasChanged()) {
            configFile.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)new TileEntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)DelayedEntityLoadManager.instance);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        syncableManager = new SyncableManager();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        Integration.selectModules();
    }
}

