/*
 * Decompiled with CFR 0.152.
 */
package openmods;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import openmods.api.IInventoryCallback;

public class GenericInventory
implements IInventory {
    protected List<IInventoryCallback> callbacks = new ArrayList<IInventoryCallback>();
    protected String inventoryTitle;
    protected int slotsCount;
    protected ItemStack[] inventoryContents;
    protected boolean isInvNameLocalized;

    public GenericInventory(String name, boolean isInvNameLocalized, int size) {
        this.isInvNameLocalized = isInvNameLocalized;
        this.slotsCount = size;
        this.inventoryTitle = name;
        this.inventoryContents = new ItemStack[size];
    }

    public void addCallback(IInventoryCallback callback) {
        this.callbacks.add(callback);
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.inventoryContents[par1] != null) {
            if (this.inventoryContents[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.inventoryContents[par1];
                this.inventoryContents[par1] = null;
                this.onInventoryChanged(par1);
                return itemstack;
            }
            ItemStack itemstack = this.inventoryContents[par1].func_77979_a(par2);
            if (this.inventoryContents[par1].field_77994_a == 0) {
                this.inventoryContents[par1] = null;
            }
            this.onInventoryChanged(par1);
            return itemstack;
        }
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_70303_b() {
        return this.inventoryTitle;
    }

    public int func_70302_i_() {
        return this.slotsCount;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventoryContents[i];
    }

    public ItemStack getStackInSlot(Enum<?> i) {
        return this.func_70301_a(i.ordinal());
    }

    public ItemStack func_70304_b(int i) {
        if (i >= this.inventoryContents.length) {
            return null;
        }
        if (this.inventoryContents[i] != null) {
            ItemStack itemstack = this.inventoryContents[i];
            this.inventoryContents[i] = null;
            return itemstack;
        }
        return null;
    }

    public boolean func_94042_c() {
        return this.isInvNameLocalized;
    }

    public boolean isItem(int slot, Item item) {
        return this.inventoryContents[slot] != null && this.inventoryContents[slot].func_77973_b() == item;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void onInventoryChanged(int slotNumber) {
        for (IInventoryCallback callback : this.callbacks) {
            callback.onInventoryChanged(this, slotNumber);
        }
    }

    public void func_70295_k_() {
    }

    public void clearAndSetSlotCount(int amount) {
        this.slotsCount = amount;
        this.inventoryContents = new ItemStack[amount];
        this.onInventoryChanged(0);
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("size")) {
            this.slotsCount = tag.func_74762_e("size");
        }
        NBTTagList nbttaglist = tag.func_74761_m("Items");
        this.inventoryContents = new ItemStack[this.slotsCount];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound stacktag = (NBTTagCompound)nbttaglist.func_74743_b(i);
            byte j = stacktag.func_74771_c("Slot");
            if (j < 0 || j >= this.inventoryContents.length) continue;
            this.inventoryContents[j] = ItemStack.func_77949_a((NBTTagCompound)stacktag);
        }
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventoryContents[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.onInventoryChanged(i);
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("size", this.func_70302_i_());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventoryContents.length; ++i) {
            if (this.inventoryContents[i] == null) continue;
            NBTTagCompound stacktag = new NBTTagCompound();
            stacktag.func_74774_a("Slot", (byte)i);
            this.inventoryContents[i].func_77955_b(stacktag);
            nbttaglist.func_74742_a((NBTBase)stacktag);
        }
        tag.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void func_70296_d() {
    }

    public void copyFrom(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (i >= this.func_70302_i_()) continue;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack != null) {
                this.func_70299_a(i, stack.func_77946_l());
                continue;
            }
            this.func_70299_a(i, null);
        }
    }

    public List<ItemStack> contents() {
        return Arrays.asList(this.inventoryContents);
    }
}

