/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.blocks;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.Blocks;
import biomesoplenty.blocks.renderers.RenderUtils;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockBOPColorizedLeaves
extends BlockLeavesBase
implements IShearable {
    private static final String[] leaves = new String[]{"acacia", "mangrove", "palm", "redwood", "willow", "pine"};
    private Icon[][] textures;
    public Icon christmasLights;
    private final ColourizedLeafCategory category;
    int[] adjacentTreeBlocks;

    public BlockBOPColorizedLeaves(int blockID, ColourizedLeafCategory cat) {
        super(blockID, Material.field_76257_i, false);
        this.category = cat;
        BlockBOPColorizedLeaves.setBurnProperties((int)this.field_71990_ca, (int)30, (int)60);
        this.func_71907_b(true);
        this.func_71848_c(0.2f);
        this.func_71868_h(1);
        this.func_71884_a(Block.field_71965_g);
        this.func_71849_a(BiomesOPlenty.tabBiomesOPlenty);
    }

    public void func_94332_a(IconRegister iconRegister) {
        this.textures = new Icon[3][leaves.length];
        if (Loader.isModLoaded((String)"BetterGrassAndLeavesMod")) {
            for (int i = 0; i < leaves.length; ++i) {
                this.textures[0][i] = iconRegister.func_94245_a("biomesoplenty:leaves_" + leaves[i] + "_round");
                this.textures[1][i] = iconRegister.func_94245_a("biomesoplenty:leaves_" + leaves[i] + "_fast");
                this.textures[2][i] = iconRegister.func_94245_a("biomesoplenty:better_leaves_" + leaves[i]);
            }
        } else {
            for (int i = 0; i < leaves.length; ++i) {
                this.textures[0][i] = iconRegister.func_94245_a("biomesoplenty:leaves_" + leaves[i] + "_fancy");
                this.textures[1][i] = iconRegister.func_94245_a("biomesoplenty:leaves_" + leaves[i] + "_fast");
            }
        }
        this.christmasLights = iconRegister.func_94245_a("biomesoplenty:christmaslights");
    }

    public Icon getIconBetterLeaves(int metadata, float randomIndex) {
        int type = BlockBOPColorizedLeaves.getTypeFromMeta(metadata) + this.category.ordinal() * 4;
        return this.textures[2][type >= leaves.length ? 0 : type];
    }

    public Icon getIconFallingLeaves(int metadata) {
        int type = BlockBOPColorizedLeaves.getTypeFromMeta(metadata) + this.category.ordinal() * 4;
        return this.textures[1][type >= leaves.length ? 0 : type];
    }

    public int func_71933_m() {
        double temperature = 0.5;
        double humidity = 1.0;
        return ColorizerFoliage.func_77470_a((double)temperature, (double)humidity);
    }

    public int func_71889_f_(int par1) {
        switch (par1) {
            case 0: {
                return ColorizerFoliage.func_77469_b();
            }
            case 3: {
                return ColorizerFoliage.func_77466_a();
            }
        }
        return ColorizerFoliage.func_77468_c();
    }

    public int func_71920_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int var6 = 0;
        int var7 = 0;
        int var8 = 0;
        for (int var9 = -1; var9 <= 1; ++var9) {
            for (int var10 = -1; var10 <= 1; ++var10) {
                int var11 = par1IBlockAccess.func_72807_a(par2 + var10, par4 + var9).func_76726_l();
                var6 += (var11 & 0xFF0000) >> 16;
                var7 += (var11 & 0xFF00) >> 8;
                var8 += var11 & 0xFF;
            }
        }
        return (var6 / 9 & 0xFF) << 16 | (var7 / 9 & 0xFF) << 8 | var8 / 9 & 0xFF;
    }

    public Icon func_71858_a(int side, int metadata) {
        int type = BlockBOPColorizedLeaves.getTypeFromMeta(metadata) + this.category.ordinal() * 4;
        return this.textures[!this.func_71926_d() ? 0 : 1][type >= leaves.length ? 0 : type];
    }

    public boolean func_71926_d() {
        return Block.field_71952_K.func_71926_d();
    }

    public int func_71857_b() {
        return RenderUtils.colorizedLeavesModel;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int blockID, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < 4; ++i) {
            if (this.category == ColourizedLeafCategory.CAT2 && i >= 2) continue;
            list.add(new ItemStack(blockID, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71862_a(World world, int x, int y, int z, Random random) {
        if (world.func_72951_B(x, y + 1, z) && !world.func_72797_t(x, y - 1, z) && random.nextInt(15) == 1) {
            double d0 = (float)x + random.nextFloat();
            double d1 = (double)y - 0.05;
            double d2 = (float)z + random.nextFloat();
            world.func_72869_a("dripWater", d0, d1, d2, 0.0, 0.0, 0.0);
        }
        super.func_71862_a(world, x, y, z, random);
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        int radius = 1;
        int bounds = radius + 1;
        if (world.func_72904_c(x - bounds, y - bounds, z - bounds, x + bounds, y + bounds, z + bounds)) {
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        int blockID = world.func_72798_a(x + i, y + j, z + k);
                        if (Block.field_71973_m[blockID] == null) continue;
                        Block.field_71973_m[blockID].beginLeavesDecay(world, x + i, y + j, z + k);
                    }
                }
            }
        }
    }

    public void func_71847_b(World world, int x, int y, int z, Random random) {
        if (world.field_72995_K) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 8) != 0 && (meta & 4) == 0) {
            int l1;
            int b0 = 4;
            int i1 = b0 + 1;
            int b1 = 32;
            int j1 = b1 * b1;
            int k1 = b1 / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new int[b1 * b1 * b1];
            }
            if (world.func_72904_c(x - i1, y - i1, z - i1, x + i1, y + i1, z + i1)) {
                int k2;
                int j2;
                int i2;
                for (l1 = -b0; l1 <= b0; ++l1) {
                    for (i2 = -b0; i2 <= b0; ++i2) {
                        for (j2 = -b0; j2 <= b0; ++j2) {
                            k2 = world.func_72798_a(x + l1, y + i2, z + j2);
                            Block block = Block.field_71973_m[k2];
                            this.adjacentTreeBlocks[(l1 + k1) * j1 + (i2 + k1) * b1 + j2 + k1] = block != null && block.canSustainLeaves(world, x + l1, y + i2, z + j2) ? 0 : (block != null && block.isLeaves(world, x + l1, y + i2, z + j2) ? -2 : -1);
                        }
                    }
                }
                for (l1 = 1; l1 <= 4; ++l1) {
                    for (i2 = -b0; i2 <= b0; ++i2) {
                        for (j2 = -b0; j2 <= b0; ++j2) {
                            for (k2 = -b0; k2 <= b0; ++k2) {
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + k2 + k1] != l1 - 1) continue;
                                if (this.adjacentTreeBlocks[(i2 + k1 - 1) * j1 + (j2 + k1) * b1 + k2 + k1] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1 - 1) * j1 + (j2 + k1) * b1 + k2 + k1] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1 + 1) * j1 + (j2 + k1) * b1 + k2 + k1] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1 + 1) * j1 + (j2 + k1) * b1 + k2 + k1] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1 - 1) * b1 + k2 + k1] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1 - 1) * b1 + k2 + k1] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1 + 1) * b1 + k2 + k1] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1 + 1) * b1 + k2 + k1] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + (k2 + k1 - 1)] == -2) {
                                    this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + (k2 + k1 - 1)] = l1;
                                }
                                if (this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + k2 + k1 + 1] != -2) continue;
                                this.adjacentTreeBlocks[(i2 + k1) * j1 + (j2 + k1) * b1 + k2 + k1 + 1] = l1;
                            }
                        }
                    }
                }
            }
            if ((l1 = this.adjacentTreeBlocks[k1 * j1 + k1 * b1 + k1]) >= 0) {
                world.func_72921_c(x, y, z, meta & 0xFFFFFFF7, 4);
            } else {
                this.removeLeaves(world, x, y, z);
            }
        }
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_94571_i(x, y, z);
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return ((Block)Blocks.colorizedSaplings.get()).field_71990_ca;
    }

    public int func_71899_b(int meta) {
        return BlockBOPColorizedLeaves.getTypeFromMeta(meta) + this.category.ordinal() * 4;
    }

    public int func_71873_h(World par1World, int par2, int par3, int par4) {
        return BlockBOPColorizedLeaves.getTypeFromMeta(par1World.func_72805_g(par2, par3, par4));
    }

    public int func_71925_a(Random random) {
        return random.nextInt(20) == 0 ? 1 : 0;
    }

    public boolean isShearable(ItemStack item, World world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, BlockBOPColorizedLeaves.getTypeFromMeta(world.func_72805_g(x, y, z))));
        return ret;
    }

    public String getLeafType(int metadata) {
        int type = BlockBOPColorizedLeaves.getTypeFromMeta(metadata) + this.category.ordinal() * 4;
        return leaves[type >= leaves.length ? 0 : type];
    }

    private static int getTypeFromMeta(int meta) {
        if ((meta &= 3) < 0 || meta >= leaves.length) {
            meta = 0;
        }
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void setGraphicsLevel(boolean par1) {
        this.field_72131_c = par1;
    }

    public boolean func_71877_c(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) | 8, 4);
    }

    public boolean isLeaves(World world, int x, int y, int z) {
        return true;
    }

    public static enum ColourizedLeafCategory {
        CAT1,
        CAT2,
        CAT3,
        CAT4;

    }
}

