/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.armor;

import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import tconstruct.library.armor.BehaviorDispenseArmorCopy;
import tconstruct.library.armor.EnumArmorPart;

public abstract class ArmorCore
extends ItemArmor
implements ISpecialArmor {
    public static final String SET_NAME = "TinkerArmor";
    public final EnumArmorPart armorPart;
    private static final IBehaviorDispenseItem dispenserBehavior = new BehaviorDispenseArmorCopy();
    public final int baseProtection;

    public ArmorCore(int id, int baseProtection, EnumArmorPart part) {
        super(id, EnumArmorMaterial.CHAIN, 0, part.getPartId());
        this.field_77777_bU = 1;
        this.func_77656_e(100);
        this.armorPart = part;
        this.baseProtection = baseProtection;
        BlockDispenser.field_82527_a.func_82595_a((Object)this, (Object)dispenserBehavior);
    }

    public String getArmorName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        int i = EntityLiving.func_82159_b((ItemStack)par1ItemStack) - 1;
        ItemStack itemstack1 = par3EntityPlayer.func_82169_q(i);
        if (itemstack1 == null) {
            par3EntityPlayer.func_70062_b(i + 1, par1ItemStack.func_77946_l());
            par1ItemStack.field_77994_a = 0;
        }
        return par1ItemStack;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        NBTTagCompound tags = armor.func_77978_p();
        if (tags == null) {
            return new ISpecialArmor.ArmorProperties(0, damage / (double)this.baseProtection, this.baseProtection);
        }
        NBTTagCompound data = tags.func_74775_l(SET_NAME);
        return new ISpecialArmor.ArmorProperties(0, (double)data.func_74762_e("damageReduction") / damage, data.func_74762_e("maxAbsorb"));
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return armor.func_77978_p() != null && armor.func_77978_p().func_74775_l(SET_NAME) != null ? armor.func_77978_p().func_74775_l(SET_NAME).func_74762_e("maxAbsorb") : this.baseProtection;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        NBTTagCompound data;
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            stack.func_77982_d(tags);
            data = new NBTTagCompound();
            tags.func_74766_a(SET_NAME, data);
            data.func_74768_a("damageReduction", this.baseProtection);
            data.func_74768_a("maxAbsorb", this.baseProtection);
        }
        data = tags.func_74775_l(SET_NAME);
        int dmg = data.func_74762_e("Damage");
        data.func_74768_a("Damage", dmg += damage);
    }

    public boolean func_77616_k(ItemStack par1ItemStack) {
        return false;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return this.armorPart.getPartId() == armorType;
    }

    public int getItemMaxDamageFromStack(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            return 0;
        }
        return tags.func_74775_l(SET_NAME).func_74762_e("TotalDurability");
    }

    public int getItemMaxDamageFromStackForDisplay(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            return 0;
        }
        return tags.func_74775_l(SET_NAME).func_74762_e("Damage");
    }
}

