/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import tconstruct.blocks.logic.CastingBasinLogic;
import tconstruct.blocks.logic.CastingTableLogic;
import tconstruct.blocks.logic.LavaTankLogic;
import tconstruct.library.util.IActiveLogic;

public class CastingChannelLogic
extends TileEntity
implements IFluidTank,
IFluidHandler,
IActiveLogic {
    public static final int fillMax = 720;
    public static final int outputMax = 144;
    public FluidStack liquid;
    public ForgeDirection lastProvider = ForgeDirection.UNKNOWN;
    private int ticks = 0;
    private int ticksLPReset = 0;
    public int recentlyFilledDelay = 0;
    boolean pullingLiquids;

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        ++this.ticks;
        ++this.ticksLPReset;
        if (!this.field_70331_k.field_72995_K && this.pullingLiquids) {
            this.pullLiquids();
        }
        if (this.ticks == 20) {
            if (this.recentlyFilledDelay != 0) {
                --this.recentlyFilledDelay;
            }
            if (this.recentlyFilledDelay == 0) {
                this.moveLiquidToTanks();
            }
            this.ticks = 0;
        }
        if (this.ticksLPReset == 60) {
            this.lastProvider = ForgeDirection.UNKNOWN;
            this.ticksLPReset = 0;
        }
    }

    void pullLiquids() {
        if (!(this.pullLiquid(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n, ForgeDirection.EAST) || this.pullLiquid(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n, ForgeDirection.WEST) || this.pullLiquid(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1, ForgeDirection.NORTH) || this.pullLiquid(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1, ForgeDirection.SOUTH))) {
            this.pullingLiquids = false;
        }
    }

    boolean pullLiquid(int x, int y, int z, ForgeDirection direction) {
        FluidStack templiquid;
        TileEntity tank = this.field_70331_k.func_72796_p(x, y, z);
        if (tank instanceof IFluidHandler && !(tank instanceof CastingChannelLogic) && (templiquid = ((IFluidHandler)tank).drain(direction, 3, false)) != null) {
            if (this.liquid == null) {
                if (templiquid.amount > 720) {
                    templiquid.amount = 720;
                }
                this.liquid = ((IFluidHandler)tank).drain(direction, templiquid.amount, true);
                return true;
            }
            if (this.liquid.isFluidEqual(templiquid)) {
                if (templiquid.amount + this.liquid.amount > 720) {
                    templiquid.amount = 720 - this.liquid.amount;
                }
                this.liquid.amount += ((IFluidHandler)tank).drain((ForgeDirection)direction, (int)templiquid.amount, (boolean)true).amount;
                return true;
            }
        }
        return false;
    }

    private void moveLiquidToChannels() {
        if (this.liquid == null || this.liquid.amount <= 0) {
            return;
        }
        TileEntity tankXplus = null;
        TileEntity tankXminus = null;
        TileEntity tankZplus = null;
        TileEntity tankZminus = null;
        TileEntity tankYminus = null;
        HashMap tankMap = this.getOutputs();
        if (tankMap.size() <= 0) {
            return;
        }
        boolean yFilled = false;
        if (tankMap.containsKey("yMinus")) {
            int filled;
            tankYminus = (TileEntity)tankMap.get("yMinus");
            FluidStack liquidToPush = this.drain(24, false);
            if (liquidToPush != null && liquidToPush.amount > 0 && (filled = ((IFluidHandler)tankYminus).fill(ForgeDirection.UP, liquidToPush, true)) > 0) {
                yFilled = true;
                this.drain(filled, true);
            }
        }
        if (!yFilled) {
            int filled;
            FluidStack liquidToPush;
            int divisionSurplus = this.liquid.amount % tankMap.size();
            int amountXp = 144 / tankMap.size();
            int amountXm = 144 / tankMap.size();
            int amountZp = 144 / tankMap.size();
            int amountZm = 144 / tankMap.size();
            if (divisionSurplus > 0) {
                ++amountXp;
            }
            if (divisionSurplus > 1) {
                ++amountXm;
            }
            if (divisionSurplus > 2) {
                ++amountZp;
            }
            if (tankMap.containsKey("xPlus")) {
                tankXplus = (TileEntity)tankMap.get("xPlus");
                liquidToPush = this.drain(amountXp, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((IFluidHandler)tankXplus).fill(ForgeDirection.WEST, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
            if (tankMap.containsKey("xMinus")) {
                tankXminus = (TileEntity)tankMap.get("xMinus");
                liquidToPush = this.drain(amountXm, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((IFluidHandler)tankXminus).fill(ForgeDirection.EAST, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
            if (tankMap.containsKey("zPlus")) {
                tankZplus = (TileEntity)tankMap.get("zPlus");
                liquidToPush = this.drain(amountZp, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((IFluidHandler)tankZplus).fill(ForgeDirection.NORTH, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
            if (tankMap.containsKey("zMinus")) {
                tankZminus = (TileEntity)tankMap.get("zMinus");
                liquidToPush = this.drain(amountZm, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((IFluidHandler)tankZminus).fill(ForgeDirection.SOUTH, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
        }
    }

    private void moveLiquidToTanks() {
        if (this.liquid == null || this.liquid.amount <= 0) {
            return;
        }
        TileEntity tankXplus = null;
        TileEntity tankXminus = null;
        TileEntity tankZplus = null;
        TileEntity tankZminus = null;
        TileEntity tankYminus = null;
        HashMap tankMap = this.getOutputs();
        if (tankMap.size() <= 0) {
            return;
        }
        boolean yFilled = false;
        if (tankMap.containsKey("yMinus")) {
            int filled;
            tankYminus = (TileEntity)tankMap.get("yMinus");
            FluidStack liquidToPush = this.drain(24, false);
            if (liquidToPush != null && liquidToPush.amount > 0 && (filled = ((IFluidHandler)tankYminus).fill(ForgeDirection.UP, liquidToPush, true)) > 0) {
                yFilled = true;
                this.drain(filled, true);
            }
        }
        if (!yFilled) {
            int filled;
            FluidStack liquidToPush;
            int divisionSurplus = this.liquid.amount % tankMap.size();
            int amountXp = 144 / tankMap.size();
            int amountXm = 144 / tankMap.size();
            int amountZp = 144 / tankMap.size();
            int amountZm = 144 / tankMap.size();
            if (divisionSurplus > 0) {
                ++amountXp;
            }
            if (divisionSurplus > 1) {
                ++amountXm;
            }
            if (divisionSurplus > 2) {
                ++amountZp;
            }
            if (tankMap.containsKey("xPlus")) {
                tankXplus = (TileEntity)tankMap.get("xPlus");
                liquidToPush = this.drain(amountXp, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((IFluidHandler)tankXplus).fill(ForgeDirection.WEST, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
            if (tankMap.containsKey("xMinus")) {
                tankXminus = (TileEntity)tankMap.get("xMinus");
                liquidToPush = this.drain(amountXm, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((IFluidHandler)tankXminus).fill(ForgeDirection.EAST, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
            if (tankMap.containsKey("zPlus")) {
                tankZplus = (TileEntity)tankMap.get("zPlus");
                liquidToPush = this.drain(amountZp, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((IFluidHandler)tankZplus).fill(ForgeDirection.NORTH, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
            if (tankMap.containsKey("zMinus")) {
                tankZminus = (TileEntity)tankMap.get("zMinus");
                liquidToPush = this.drain(amountZm, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((IFluidHandler)tankZminus).fill(ForgeDirection.SOUTH, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float tankBelow() {
        TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        if (te instanceof CastingChannelLogic) {
            return -0.5f;
        }
        if (te instanceof LavaTankLogic) {
            return -1.0f;
        }
        if (te instanceof CastingBasinLogic) {
            return -0.75f;
        }
        if (te instanceof CastingTableLogic) {
            return -0.125f;
        }
        if (te instanceof IFluidHandler) {
            return 0.0f;
        }
        return 0.5f;
    }

    public boolean hasChannelConnected(ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) instanceof CastingChannelLogic;
            }
            case NORTH: {
                return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) instanceof CastingChannelLogic;
            }
            case SOUTH: {
                return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) instanceof CastingChannelLogic;
            }
            case WEST: {
                return this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) instanceof CastingChannelLogic;
            }
            case EAST: {
                return this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) instanceof CastingChannelLogic;
            }
        }
        return false;
    }

    public boolean hasTankConnected(ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) instanceof IFluidHandler;
            }
            case NORTH: {
                return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) instanceof IFluidHandler;
            }
            case SOUTH: {
                return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) instanceof IFluidHandler;
            }
            case WEST: {
                return this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) instanceof IFluidHandler;
            }
            case EAST: {
                return this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) instanceof IFluidHandler;
            }
        }
        return false;
    }

    private HashMap getOutputs() {
        HashMap<String, TileEntity> map = new HashMap<String, TileEntity>();
        TileEntity tankXplus = this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n);
        TileEntity tankXminus = this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n);
        TileEntity tankZplus = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1);
        TileEntity tankZminus = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
        TileEntity tankYminus = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        if (this.pullingLiquids) {
            if (this.hasChannelConnected(ForgeDirection.EAST) && this.lastProvider != ForgeDirection.EAST) {
                map.put("xPlus", tankXplus);
            }
            if (this.hasChannelConnected(ForgeDirection.WEST) && this.lastProvider != ForgeDirection.WEST) {
                map.put("xMinus", tankXminus);
            }
            if (this.hasChannelConnected(ForgeDirection.SOUTH) && this.lastProvider != ForgeDirection.SOUTH) {
                map.put("zPlus", tankZplus);
            }
            if (this.hasChannelConnected(ForgeDirection.NORTH) && this.lastProvider != ForgeDirection.NORTH) {
                map.put("zMinus", tankZminus);
            }
            if (this.hasChannelConnected(ForgeDirection.DOWN) && this.lastProvider != ForgeDirection.DOWN) {
                map.put("yMinus", tankYminus);
            }
        } else {
            if (this.hasTankConnected(ForgeDirection.EAST) && this.lastProvider != ForgeDirection.EAST) {
                map.put("xPlus", tankXplus);
            }
            if (this.hasTankConnected(ForgeDirection.WEST) && this.lastProvider != ForgeDirection.WEST) {
                map.put("xMinus", tankXminus);
            }
            if (this.hasTankConnected(ForgeDirection.SOUTH) && this.lastProvider != ForgeDirection.SOUTH) {
                map.put("zPlus", tankZplus);
            }
            if (this.hasTankConnected(ForgeDirection.NORTH) && this.lastProvider != ForgeDirection.NORTH) {
                map.put("zMinus", tankZminus);
            }
            if (this.hasTankConnected(ForgeDirection.DOWN) && this.lastProvider != ForgeDirection.DOWN) {
                map.put("yMinus", tankYminus);
            }
        }
        return map;
    }

    public int fill(FluidStack stack, boolean doFill) {
        if (stack == null) {
            return 0;
        }
        if (this.liquid == null) {
            FluidStack transfered = stack.copy();
            if (transfered.amount > 720) {
                transfered.amount = 720;
            }
            if (doFill) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.liquid = transfered;
            }
            this.recentlyFilledDelay = 2;
            if (this.lastProvider == ForgeDirection.UP) {
                this.recentlyFilledDelay = 3;
            }
            return transfered.amount;
        }
        if (stack.isFluidEqual(this.liquid)) {
            if (stack.amount + this.liquid.amount >= 720) {
                int spaceInTank = 720 - this.liquid.amount;
                if (doFill && spaceInTank > 0) {
                    this.liquid.amount = 720;
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
                return spaceInTank;
            }
            if (doFill) {
                this.liquid.amount += stack.amount;
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            return stack.amount;
        }
        return 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        this.lastProvider = from;
        this.ticksLPReset = 0;
        int filled = this.fill(resource, doFill);
        if (from == ForgeDirection.UP) {
            this.moveLiquidToTanks();
        }
        return filled;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquid == null) {
            return null;
        }
        if (this.liquid.amount <= 0) {
            return null;
        }
        int toDrain = maxDrain;
        if (this.liquid.amount < toDrain) {
            toDrain = this.liquid.amount;
        }
        if (doDrain) {
            this.liquid.amount -= toDrain;
        }
        FluidStack drained = new FluidStack(this.liquid.fluidID, toDrain);
        if (this.liquid.amount <= 0) {
            this.liquid = null;
        }
        if (doDrain) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(drained, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, (IFluidTank)this));
        }
        return drained;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(resource.amount, doDrain);
    }

    public int getCapacity() {
        return 720;
    }

    public int getLiquidAmount() {
        return this.liquid.amount;
    }

    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.readCustomNBT(tags);
        this.pullingLiquids = tags.func_74767_n("PullingLiquids");
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.liquid = tags.func_74767_n("hasLiquid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tags.func_74775_l("Fluid")) : null;
        this.recentlyFilledDelay = tags.func_74762_e("recentlyFilledDelay");
        this.lastProvider = this.convertIntToFD(tags.func_74762_e("LastProvider"));
    }

    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.writeCustomNBT(tags);
        tags.func_74757_a("PullingLiquids", this.pullingLiquids);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74757_a("hasLiquid", this.liquid != null);
        if (this.liquid != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.liquid.writeToNBT(nbt);
            tags.func_74766_a("Fluid", nbt);
        }
        tags.func_74768_a("LastProvider", this.convertFDToInt(this.lastProvider));
        tags.func_74768_a("recentlyFilledDelay", this.recentlyFilledDelay);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.readCustomNBT(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int convertFDToInt(ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return -1;
    }

    public ForgeDirection convertIntToFD(int i) {
        switch (i) {
            case 0: {
                return ForgeDirection.DOWN;
            }
            case 1: {
                return ForgeDirection.UP;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
            case 4: {
                return ForgeDirection.WEST;
            }
            case 5: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public boolean getActive() {
        return this.pullingLiquids;
    }

    @Override
    public void setActive(boolean flag) {
        this.pullingLiquids = !this.pullingLiquids;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.liquid == null || this.liquid.amount < 720;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getInfo()};
    }

    public FluidStack getFluid() {
        return this.liquid == null ? null : this.liquid.copy();
    }

    public int getFluidAmount() {
        return this.liquid == null ? 0 : this.liquid.amount;
    }

    public FluidTankInfo getInfo() {
        FluidTankInfo info = new FluidTankInfo((IFluidTank)this);
        return info;
    }
}

