/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.mobiuscore.asm;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import mcp.mobius.mobiuscore.asm.TransformerBase;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TransformerWorld
extends TransformerBase {
    private static String WORLD_UPDATEENTITIES;
    private static AbstractInsnNode[] WORLD_UPDATE_PATTERN_TEUPDATE;
    private static AbstractInsnNode[] WORLD_UPDATE_PAYLOAD_START_TEUPDATE;
    private static AbstractInsnNode[] WORLD_UPDATE_PAYLOAD_STOP_TEUPDATE;
    private static AbstractInsnNode[] WORLD_UPDATE_PATTERN_ENTUPDATE;
    private static AbstractInsnNode[] WORLD_UPDATE_PAYLOAD_START_ENTUPDATE;
    private static AbstractInsnNode[] WORLD_UPDATE_PAYLOAD_STOP_ENTUPDATE;
    private static AbstractInsnNode[] WORLD_UPDATE_PAYLOAD_START_ENTUPDATE_MCPC;
    private static AbstractInsnNode[] WORLD_UPDATE_PAYLOAD_STOP_ENTUPDATE_MCPC;
    private static boolean isEclipse;
    private static HashMap<String, String> obfTable;

    private static String getCorrectName(String key) {
        if (isEclipse) {
            return obfTable.get(key);
        }
        return key;
    }

    @Override
    public byte[] transform(String name, String srgname, byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode methodNode : classNode.methods) {
            if (!String.format("%s %s", methodNode.name, methodNode.desc).equals(WORLD_UPDATEENTITIES)) continue;
            System.out.printf("Found World.updateEntities()... \n", new Object[0]);
            InsnList instructions = methodNode.instructions;
            ListIterator iterator = instructions.iterator();
            ArrayList<AbstractInsnNode> match = this.findPattern(methodNode, WORLD_UPDATE_PATTERN_TEUPDATE);
            if (match != null) {
                System.out.printf("Trying to inject tile entity profiler... ", new Object[0]);
                this.applyPayloadBefore(instructions, match, WORLD_UPDATE_PAYLOAD_START_TEUPDATE);
                this.applyPayloadAfter(instructions, match, WORLD_UPDATE_PAYLOAD_STOP_TEUPDATE);
                System.out.printf("Successful injection !\n", new Object[0]);
            } else {
                System.out.printf("Error while injecting !\n", new Object[0]);
            }
            match = this.findPattern(methodNode, WORLD_UPDATE_PATTERN_ENTUPDATE);
            if (match != null) {
                System.out.printf("Trying to inject entity profiler... ", new Object[0]);
                AbstractInsnNode[] PrevPayload = WORLD_UPDATE_PAYLOAD_START_ENTUPDATE;
                AbstractInsnNode[] NextPayload = WORLD_UPDATE_PAYLOAD_STOP_ENTUPDATE;
                VarInsnNode aload = (VarInsnNode)match.get(2);
                if (aload.var == 4) {
                    PrevPayload = WORLD_UPDATE_PAYLOAD_START_ENTUPDATE_MCPC;
                    NextPayload = WORLD_UPDATE_PAYLOAD_STOP_ENTUPDATE_MCPC;
                }
                this.applyPayloadBefore(instructions, match, PrevPayload);
                this.applyPayloadAfter(instructions, match, NextPayload);
                System.out.printf("Successful injection !\n", new Object[0]);
                continue;
            }
            System.out.printf("Error while injecting !\n", new Object[0]);
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    static {
        obfTable = new HashMap();
        isEclipse = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
        obfTable.put("h ()V", "updateEntities ()V");
        obfTable.put("asp", "net/minecraft/tileentity/TileEntity");
        obfTable.put("h", "updateEntity");
        obfTable.put("g", "updateEntity");
        obfTable.put("(Lasp;)V", "(Lnet/minecraft/tileentity/TileEntity;)V");
        obfTable.put("(Lnn;)V", "(Lnet/minecraft/entity/Entity;)V");
        obfTable.put("abw", "net/minecraft/world/World");
        WORLD_UPDATEENTITIES = TransformerWorld.getCorrectName("h ()V");
        WORLD_UPDATE_PATTERN_TEUPDATE = new AbstractInsnNode[]{new LineNumberNode(-1, new LabelNode()), new VarInsnNode(25, -1), new MethodInsnNode(182, TransformerWorld.getCorrectName("asp"), TransformerWorld.getCorrectName("h"), "()V")};
        WORLD_UPDATE_PAYLOAD_START_TEUPDATE = new AbstractInsnNode[]{new FieldInsnNode(178, "mcp/mobius/mobiuscore/profiler/ProfilerRegistrar", "profilerTileEntity", "Lmcp/mobius/mobiuscore/profiler/IProfilerTileEntity;"), new VarInsnNode(25, 8), new MethodInsnNode(185, "mcp/mobius/mobiuscore/profiler/IProfilerTileEntity", "Start", TransformerWorld.getCorrectName("(Lasp;)V"))};
        WORLD_UPDATE_PAYLOAD_STOP_TEUPDATE = new AbstractInsnNode[]{new FieldInsnNode(178, "mcp/mobius/mobiuscore/profiler/ProfilerRegistrar", "profilerTileEntity", "Lmcp/mobius/mobiuscore/profiler/IProfilerTileEntity;"), new VarInsnNode(25, 8), new MethodInsnNode(185, "mcp/mobius/mobiuscore/profiler/IProfilerTileEntity", "Stop", TransformerWorld.getCorrectName("(Lasp;)V"))};
        WORLD_UPDATE_PATTERN_ENTUPDATE = new AbstractInsnNode[]{new LineNumberNode(-1, new LabelNode()), new VarInsnNode(25, -1), new VarInsnNode(25, -1), new MethodInsnNode(182, TransformerWorld.getCorrectName("abw"), TransformerWorld.getCorrectName("g"), TransformerWorld.getCorrectName("(Lnn;)V"))};
        WORLD_UPDATE_PAYLOAD_START_ENTUPDATE = new AbstractInsnNode[]{new FieldInsnNode(178, "mcp/mobius/mobiuscore/profiler/ProfilerRegistrar", "profilerEntity", "Lmcp/mobius/mobiuscore/profiler/IProfilerEntity;"), new VarInsnNode(25, 2), new MethodInsnNode(185, "mcp/mobius/mobiuscore/profiler/IProfilerEntity", "Start", TransformerWorld.getCorrectName("(Lnn;)V"))};
        WORLD_UPDATE_PAYLOAD_STOP_ENTUPDATE = new AbstractInsnNode[]{new FieldInsnNode(178, "mcp/mobius/mobiuscore/profiler/ProfilerRegistrar", "profilerEntity", "Lmcp/mobius/mobiuscore/profiler/IProfilerEntity;"), new VarInsnNode(25, 2), new MethodInsnNode(185, "mcp/mobius/mobiuscore/profiler/IProfilerEntity", "Stop", TransformerWorld.getCorrectName("(Lnn;)V"))};
        WORLD_UPDATE_PAYLOAD_START_ENTUPDATE_MCPC = new AbstractInsnNode[]{new FieldInsnNode(178, "mcp/mobius/mobiuscore/profiler/ProfilerRegistrar", "profilerEntity", "Lmcp/mobius/mobiuscore/profiler/IProfilerEntity;"), new VarInsnNode(25, 4), new MethodInsnNode(185, "mcp/mobius/mobiuscore/profiler/IProfilerEntity", "Start", TransformerWorld.getCorrectName("(Lnn;)V"))};
        WORLD_UPDATE_PAYLOAD_STOP_ENTUPDATE_MCPC = new AbstractInsnNode[]{new FieldInsnNode(178, "mcp/mobius/mobiuscore/profiler/ProfilerRegistrar", "profilerEntity", "Lmcp/mobius/mobiuscore/profiler/IProfilerEntity;"), new VarInsnNode(25, 4), new MethodInsnNode(185, "mcp/mobius/mobiuscore/profiler/IProfilerEntity", "Stop", TransformerWorld.getCorrectName("(Lnn;)V"))};
    }
}

