/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.ReflectionManager;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.File;
import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.DimensionManager;

public class CommonUtils {
    private static File minecraftDir;
    private static byte[] charWidth;

    public static boolean isClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    public static File getWorldSaveLocation(abw world, int dimension) {
        File basesave = DimensionManager.getCurrentSaveRootDirectory();
        if (dimension != 0) {
            return new File(basesave, world.t.getSaveFolder());
        }
        return basesave;
    }

    public static String getWorldName(abw world) {
        return world.N().k();
    }

    public static int getDimension(abw world) {
        return world.t.i;
    }

    public static File getModsFolder() {
        return new File(CommonUtils.getMinecraftDir(), "mods");
    }

    public static File getMinecraftDir() {
        if (minecraftDir == null) {
            minecraftDir = ReflectionManager.getField(Loader.class, File.class, (Object)Loader.instance(), "minecraftDir");
        }
        return minecraftDir;
    }

    public static String getRelativePath(File parent, File child) {
        if (parent.isFile() || !child.getPath().startsWith(parent.getPath())) {
            return null;
        }
        return child.getPath().substring(parent.getPath().length() + 1);
    }

    public static int getFreeBlockID(int preferred) {
        int i;
        for (i = preferred; i < 255; ++i) {
            if (aqz.s[i] != null) continue;
            return i;
        }
        for (i = preferred - 1; i > 0; --i) {
            if (aqz.s[i] != null) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] subArray(T[] args, int i) {
        if (i > args.length) {
            return (Object[])Array.newInstance(args.getClass().getComponentType(), 0);
        }
        Object[] narray = (Object[])Array.newInstance(args.getClass().getComponentType(), args.length - i);
        System.arraycopy(args, i, narray, 0, narray.length);
        return narray;
    }

    public static int getCharWidth(char c) {
        if (c == '\u00a7') {
            return -1;
        }
        int charIndex = v.a.indexOf(c);
        if (charIndex + 32 > charWidth.length || charIndex < 0) {
            return 0;
        }
        return charWidth[charIndex + 32];
    }

    public static int getStringWidth(String s) {
        if (s == null) {
            return 0;
        }
        int width = 0;
        boolean var3 = false;
        for (int charIndex = 0; charIndex < s.length(); ++charIndex) {
            char c = s.charAt(charIndex);
            int charWidth = CommonUtils.getCharWidth(c);
            if (charWidth < 0 && charIndex < s.length() - 1) {
                if ((c = s.charAt(++charIndex)) != 'l' && c != 'L') {
                    if (c == 'r' || c == 'R') {
                        var3 = false;
                    }
                } else {
                    var3 = true;
                }
                charWidth = CommonUtils.getCharWidth(c);
            }
            width += charWidth;
            if (!var3) continue;
            ++width;
        }
        return width;
    }

    public static List<String> splitChat(String message) {
        LinkedList<String> splitNotice = new LinkedList<String>();
        String[] splits = message.split(" ");
        String partial = "";
        int colour = 7;
        for (int i = 0; i < splits.length; ++i) {
            String next;
            String string = next = partial.length() == 0 ? splits[i] : partial + " " + splits[i];
            if (CommonUtils.getStringWidth(next) > 377) {
                splitNotice.add(CommonUtils.colourPrefix(colour) + partial);
                for (int charPos = 0; charPos < partial.length(); ++charPos) {
                    while (partial.length() > charPos + 1 && partial.charAt(charPos) == '\u00a7') {
                        char c = partial.toLowerCase().charAt(charPos + 1);
                        if (c != 'k' && ((colour = "0123456789abcdef".indexOf(c)) < 0 || colour > 15)) {
                            colour = 15;
                        }
                        ++charPos;
                    }
                }
                partial = splits[i];
                continue;
            }
            partial = next;
        }
        splitNotice.add(CommonUtils.colourPrefix(colour) + partial);
        return splitNotice;
    }

    public static String colourPrefix(int colour) {
        if (colour == -1) {
            return "";
        }
        return "\u00a7" + "0123456789abcdef".charAt(colour);
    }

    public static boolean isBlock(int ID) {
        return ID < aqz.s.length && aqz.s[ID] != null && aqz.s[ID].cF != 0;
    }

    public static ModContainer findModContainer(String modID) {
        for (ModContainer mc : Loader.instance().getModList()) {
            if (!modID.equals(mc.getModId())) continue;
            return mc;
        }
        return null;
    }

    public static ye consumeItem(ye stack) {
        if (stack.b().u()) {
            return stack.b().getContainerItemStack(stack);
        }
        if (stack.b == 1) {
            return null;
        }
        --stack.b;
        return stack;
    }

    public static String filterText(String s) {
        return v.a((String)s.replaceAll("\u00a7.", ""));
    }

    static {
        charWidth = new byte[]{4, 2, 5, 6, 6, 6, 6, 3, 5, 5, 5, 6, 2, 6, 2, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 2, 2, 5, 6, 5, 6, 7, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 4, 6, 6, 3, 6, 6, 6, 6, 6, 5, 6, 6, 2, 6, 5, 3, 6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 6, 6, 6, 6, 5, 2, 5, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 3, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 3, 6, 6, 6, 6, 6, 6, 6, 7, 6, 6, 6, 2, 6, 6};
    }
}

