/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocator;

import codechicken.core.fluid.FluidUtils;
import codechicken.core.fluid.TankAccess;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.translocator.TileTranslocator;
import codechicken.translocator.TranslocatorSPH;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileLiquidTranslocator
extends TileTranslocator
implements IFluidHandler {
    public LinkedList<MovingLiquid> movingLiquids = new LinkedList();
    public LinkedList<MovingLiquid> exitingLiquids = new LinkedList();

    @Override
    public void h() {
        super.h();
        if (this.k.I) {
            Iterator iterator = this.movingLiquids.iterator();
            while (iterator.hasNext()) {
                MovingLiquid m = (MovingLiquid)iterator.next();
                if (!m.update()) continue;
                iterator.remove();
                this.exitingLiquids.add(m);
            }
            iterator = this.exitingLiquids.iterator();
            while (iterator.hasNext()) {
                if (!((MovingLiquid)iterator.next()).update()) continue;
                iterator.remove();
            }
        } else {
            BlockCoord pos = new BlockCoord((asp)this);
            TankAccess[] attached = new TankAccess[6];
            int[] outputs = null;
            int[] r_outputs = null;
            int i = 0;
            while (i < 6) {
                TileTranslocator.Attachment a = this.attachments[i];
                if (a != null) {
                    BlockCoord invpos = pos.copy().offset(i);
                    asp tile = this.k.r(invpos.x, invpos.y, invpos.z);
                    if (!(tile instanceof IFluidHandler)) {
                        this.harvestPart(i, true);
                    } else {
                        attached[i] = new TankAccess((IFluidHandler)tile, i ^ 1);
                    }
                }
                ++i;
            }
            ArrayList<LiquidTransfer> transfers = new ArrayList<LiquidTransfer>();
            int i2 = 0;
            while (i2 < 6) {
                TileTranslocator.Attachment a = this.attachments[i2];
                if (a != null && a.a_eject) {
                    TankAccess t = attached[i2];
                    FluidStack drain = t.drain(a.fast ? 1000 : 100, false);
                    if (drain != null && drain.amount != 0) {
                        if (outputs == null) {
                            outputs = this.sortOutputs(false);
                            r_outputs = this.sortOutputs(true);
                        }
                        FluidStack move = drain.copy();
                        this.spreadOutput(move, i2, outputs, attached, transfers);
                        this.spreadOutput(move, i2, r_outputs, attached, transfers);
                        t.drain(drain.amount - move.amount, true);
                    }
                }
                ++i2;
            }
            if (!transfers.isEmpty()) {
                this.sendTransferPacket(transfers);
            }
        }
    }

    private void spreadOutput(FluidStack move, int src, int[] outputs, TankAccess[] attached, ArrayList<LiquidTransfer> transfers) {
        int k = 0;
        while (k < outputs.length && move.amount > 0) {
            int dst = outputs[k];
            TankAccess outaccess = attached[dst];
            int fit = outaccess.fill(move, false);
            int spread = outputs.length - k;
            if ((fit = Math.min(fit, move.amount / spread + this.k.s.nextInt(move.amount % spread + 1))) != 0) {
                FluidStack add = FluidUtils.copy((FluidStack)move, (int)fit);
                outaccess.fill(add, true);
                move.amount -= fit;
                transfers.add(new LiquidTransfer(src, dst, add));
            }
            ++k;
        }
    }

    public int[] sortOutputs(boolean b) {
        int[] str = new int[6];
        int k = 0;
        int i = 0;
        while (i < 6) {
            TileTranslocator.Attachment a = this.attachments[i];
            if (a != null && !a.a_eject && a.redstone == b) {
                str[k++] = i;
            }
            ++i;
        }
        int[] ret = new int[k];
        System.arraycopy(str, 0, ret, 0, k);
        return ret;
    }

    private void sendTransferPacket(ArrayList<LiquidTransfer> transfers) {
        PacketCustom packet = new PacketCustom(TranslocatorSPH.channel, 2);
        packet.setChunkDataPacket();
        packet.writeCoord(this.l, this.m, this.n);
        packet.writeByte(transfers.size());
        for (LiquidTransfer t : transfers) {
            packet.writeByte(t.key);
            packet.writeFluidStack(t.liquid);
        }
        packet.sendToChunk(this.k, this.l >> 4, this.n >> 4);
    }

    @Override
    public void handleDescriptionPacket(PacketCustom packet) {
        if (packet.getType() == 2) {
            ArrayList<LiquidTransfer> transfers = new ArrayList<LiquidTransfer>();
            HashSet<Integer> maintainingKeys = new HashSet<Integer>();
            int k = packet.readUByte();
            int i = 0;
            while (i < k) {
                LiquidTransfer t = new LiquidTransfer(packet.readUByte(), packet.readFluidStack());
                transfers.add(t);
                maintainingKeys.add(t.key);
                ++i;
            }
            for (LiquidTransfer t : transfers) {
                int src = t.key >> 4;
                int dst = t.key & 0xF;
                boolean found = false;
                Iterator iterator = this.movingLiquids.iterator();
                while (iterator.hasNext()) {
                    MovingLiquid m = (MovingLiquid)iterator.next();
                    if (m.liquid.isFluidEqual(t.liquid) && m.src == src && m.dst == dst) {
                        m.addLiquid(t.liquid.amount);
                        found = true;
                        continue;
                    }
                    if (m.dst != dst && m.src != src || maintainingKeys.contains(m.src << 4 | m.dst)) continue;
                    iterator.remove();
                    m.finish();
                    this.exitingLiquids.add(m);
                }
                if (found || this.attachments[src] == null) continue;
                this.movingLiquids.add(new MovingLiquid(src, dst, t.liquid));
            }
        } else {
            super.handleDescriptionPacket(packet);
        }
    }

    public Iterable<MovingLiquid> movingLiquids() {
        ArrayList<MovingLiquid> comp = new ArrayList<MovingLiquid>();
        comp.addAll(this.movingLiquids);
        comp.addAll(this.exitingLiquids);
        return comp;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == ForgeDirection.UNKNOWN) {
            LinkedList<FluidTankInfo> list = new LinkedList<FluidTankInfo>();
            TileTranslocator.Attachment[] attachmentArray = this.attachments;
            int n = this.attachments.length;
            int n2 = 0;
            while (n2 < n) {
                TileTranslocator.Attachment a = attachmentArray[n2];
                if (a != null) {
                    list.add(new FluidTankInfo(null, 0));
                }
                ++n2;
            }
            return list.toArray(new FluidTankInfo[0]);
        }
        if (this.attachments[from.ordinal()] != null) {
            return new FluidTankInfo[]{new FluidTankInfo(null, 0)};
        }
        return new FluidTankInfo[0];
    }

    private class LiquidTransfer {
        int key;
        FluidStack liquid;

        public LiquidTransfer(int src, int dst, FluidStack liquid) {
            this.key = src << 4 | dst;
            this.liquid = liquid;
        }

        public LiquidTransfer(int key, FluidStack liquid) {
            this.key = key;
            this.liquid = liquid;
        }
    }

    public class MovingLiquid {
        public int src;
        public int dst;
        public FluidStack liquid;
        public double a_start;
        public double b_start;
        public double a_end;
        public double b_end;
        public boolean fast;

        public MovingLiquid(int src, int dst, FluidStack add) {
            this.src = src;
            this.dst = dst;
            this.liquid = add;
            this.fast = TileLiquidTranslocator.this.attachments[src].fast;
            this.capLiquid();
        }

        private void capLiquid() {
            this.liquid.amount = Math.min(this.liquid.amount, this.fast ? 1000 : 100);
        }

        public boolean update() {
            if (this.a_end == 1.0) {
                return true;
            }
            this.b_start = this.a_start;
            this.a_start = MathHelper.approachLinear((double)this.a_start, (double)1.0, (double)0.2);
            this.b_end = this.a_end;
            if (this.liquid.amount > 0) {
                this.liquid.amount = Math.max(this.liquid.amount - (this.fast ? 200 : 20), 0);
                return this.liquid.amount == 0;
            }
            this.a_end = MathHelper.approachLinear((double)this.a_end, (double)1.0, (double)0.2);
            return false;
        }

        public void addLiquid(int moving) {
            if (this.liquid.amount == 0) {
                throw new IllegalArgumentException("Something went wrong!");
            }
            this.liquid.amount += moving;
            if (TileLiquidTranslocator.this.attachments[this.src] != null) {
                this.fast = TileLiquidTranslocator.this.attachments[this.src].fast;
            }
            this.capLiquid();
        }

        public void finish() {
            this.liquid.amount = 0;
        }
    }
}

