/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocator;

import codechicken.core.IGuiPacketSender;
import codechicken.core.ServerUtils;
import codechicken.core.inventory.InventoryRange;
import codechicken.core.inventory.InventorySimple;
import codechicken.core.inventory.InventoryUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.translocator.ContainerItemTranslocator;
import codechicken.translocator.TileTranslocator;
import codechicken.translocator.Translocator;
import codechicken.translocator.TranslocatorSPH;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class TileItemTranslocator
extends TileTranslocator {
    public LinkedList<MovingItem> movingItems = new LinkedList();

    @Override
    public void a(by tag) {
        super.a(tag);
        if (tag.b("items")) {
            TileTranslocator.Attachment[] attachmentArray = this.attachments;
            int n = this.attachments.length;
            int n2 = 0;
            while (n2 < n) {
                TileTranslocator.Attachment a = attachmentArray[n2];
                if (a != null) {
                    InventoryUtils.readItemStacksFromTag((ye[])((ItemAttachment)a).filters, (cg)tag.m("items"));
                }
                ++n2;
            }
        }
    }

    @Override
    public void createAttachment(int side) {
        this.attachments[side] = new ItemAttachment(side);
    }

    @Override
    public void h() {
        super.h();
        if (this.k.I) {
            Iterator iterator = this.movingItems.iterator();
            while (iterator.hasNext()) {
                if (!((MovingItem)iterator.next()).update()) continue;
                iterator.remove();
            }
        } else {
            ItemAttachment ia;
            BlockCoord pos = new BlockCoord((asp)this);
            InventoryRange[] attached = new InventoryRange[6];
            int i = 0;
            while (i < 6) {
                TileTranslocator.Attachment a = this.attachments[i];
                if (a != null) {
                    BlockCoord invpos = pos.copy().offset(i);
                    mo inv = InventoryUtils.getInventory((abw)this.k, (int)invpos.x, (int)invpos.y, (int)invpos.z);
                    if (inv == null) {
                        this.harvestPart(i, true);
                    } else {
                        attached[i] = new InventoryRange(inv, i ^ 1);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < 6) {
                ItemAttachment ia2 = (ItemAttachment)this.attachments[i];
                if (ia2 != null && ia2.a_eject) {
                    int largestQuantity = 0;
                    int largestSlot = 0;
                    InventoryRange access = attached[i];
                    int[] nArray = access.slots;
                    int n = access.slots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int slot = nArray[n2];
                        ye stack = access.inv.a(slot);
                        if (stack != null && access.canExtractItem(slot, stack) && stack.b != 0) {
                            int quantity;
                            int n3 = quantity = ia2.fast ? stack.b : 1;
                            if (quantity > largestQuantity && (quantity = Math.min(quantity, this.extractAmount(stack, ia2, access))) > largestQuantity && (quantity = Math.min(quantity, this.insertAmount(stack, attached))) > largestQuantity) {
                                largestSlot = slot;
                                largestQuantity = quantity;
                            }
                        }
                        ++n2;
                    }
                    if (largestQuantity > 0) {
                        ye move = InventoryUtils.copyStack((ye)access.inv.a(largestSlot), (int)largestQuantity);
                        this.spreadOutput(move, i, false, attached);
                        this.spreadOutput(move, i, true, attached);
                        InventoryUtils.decrStackSize((mo)access.inv, (int)largestSlot, (int)(largestQuantity - move.b));
                    }
                }
                ++i;
            }
            boolean allSatisfied = true;
            int i2 = 0;
            while (i2 < 6) {
                ia = (ItemAttachment)this.attachments[i2];
                if (ia != null && !ia.a_eject) {
                    boolean b = this.isSatsified(ia, attached[i2]);
                    ia.setPowering(b);
                    if (!b) {
                        allSatisfied = false;
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 6) {
                ia = (ItemAttachment)this.attachments[i2];
                if (ia != null && ia.signal && ia.a_eject) {
                    ia.setPowering(allSatisfied || !this.canTransferFilter(ia, attached[i2], attached));
                }
                ++i2;
            }
        }
    }

    private boolean matches(ye stack, ye filter) {
        return stack.d == filter.d && (!filter.h() || filter.k() == stack.k()) && ye.a((ye)filter, (ye)stack);
    }

    private boolean canTransferFilter(ItemAttachment ia, InventoryRange access, InventoryRange[] attached) {
        boolean filterSet = false;
        ye[] yeArray = ia.filters;
        int n = ia.filters.length;
        int n2 = 0;
        while (n2 < n) {
            ye filter = yeArray[n2];
            if (filter != null) {
                filterSet = true;
                if (!(ia.regulate && this.countMatchingStacks(access, filter, false) <= this.filterCount(ia, filter) || this.insertAmount(filter, attached) <= 0)) {
                    return true;
                }
            }
            ++n2;
        }
        return !filterSet;
    }

    private boolean isSatsified(ItemAttachment ia, InventoryRange access) {
        boolean filterSet = false;
        ye[] yeArray = ia.filters;
        int n = ia.filters.length;
        int n2 = 0;
        while (n2 < n) {
            ye filter = yeArray[n2];
            if (filter != null) {
                filterSet = true;
                if (ia.regulate ? this.countMatchingStacks(access, filter, !ia.a_eject) < this.filterCount(ia, filter) : InventoryUtils.getInsertableQuantity((InventoryRange)access, (ye)filter) > 0) {
                    return false;
                }
            }
            ++n2;
        }
        return filterSet || !this.hasEmptySpace(access);
    }

    private boolean hasEmptySpace(InventoryRange inv) {
        int[] nArray = inv.slots;
        int n = inv.slots.length;
        int n2 = 0;
        while (n2 < n) {
            int slot = nArray[n2];
            ye stack = inv.inv.a(slot);
            if (inv.canInsertItem(slot, new ye(yc.p)) && (stack == null || stack.f() && stack.b < Math.min(stack.e(), inv.inv.d()))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int filterCount(ItemAttachment ia, ye stack) {
        boolean filterSet = false;
        int match = 0;
        ye[] yeArray = ia.filters;
        int n = ia.filters.length;
        int n2 = 0;
        while (n2 < n) {
            ye filter = yeArray[n2];
            if (filter != null) {
                filterSet = true;
                if (this.matches(stack, filter)) {
                    match += filter.b;
                }
            }
            ++n2;
        }
        return filterSet ? match : -1;
    }

    private void spreadOutput(ye move, int src, boolean rspass, InventoryRange[] attached) {
        if (move.b == 0) {
            return;
        }
        int outputCount = 0;
        int[] outputQuantities = new int[6];
        int i = 0;
        while (i < 6) {
            ItemAttachment ia = (ItemAttachment)this.attachments[i];
            if (ia != null && !ia.a_eject && ia.redstone == rspass) {
                outputQuantities[i] = this.insertAmount(move, ia, attached[i]);
                if (outputQuantities[i] > 0) {
                    ++outputCount;
                }
            }
            ++i;
        }
        int dst = 0;
        while (dst < 6 && move.b > 0) {
            int qty = outputQuantities[dst];
            if (qty > 0) {
                qty = Math.min(qty, move.b / outputCount + this.k.s.nextInt(move.b % outputCount + 1));
                --outputCount;
                if (qty != 0) {
                    InventoryRange range = attached[dst];
                    ye add = InventoryUtils.copyStack((ye)move, (int)qty);
                    InventoryUtils.mergeItemStack((InventoryRange)range, (ye)add, (boolean)true);
                    move.b -= qty;
                    this.sendTransferPacket(src, dst, add);
                }
            }
            ++dst;
        }
    }

    private int countMatchingStacks(InventoryRange inv, ye filter, boolean insertable) {
        int c = 0;
        int[] nArray = inv.slots;
        int n = inv.slots.length;
        int n2 = 0;
        while (n2 < n) {
            int slot = nArray[n2];
            ye stack = inv.inv.a(slot);
            if (stack != null && this.matches(filter, stack) && (insertable ? inv.canInsertItem(slot, stack) : inv.canExtractItem(slot, stack))) {
                c += stack.b;
            }
            ++n2;
        }
        return c;
    }

    private void sendTransferPacket(int i, int j, ye add) {
        PacketCustom packet = new PacketCustom(TranslocatorSPH.channel, 2);
        packet.writeCoord(this.l, this.m, this.n);
        packet.writeByte(i << 4 | j);
        packet.writeItemStack(add);
        packet.sendToChunk(this.k, this.l >> 4, this.n >> 4);
    }

    private int insertAmount(ye stack, InventoryRange[] attached) {
        int insertAmount = 0;
        int i = 0;
        while (i < 6) {
            ItemAttachment ia = (ItemAttachment)this.attachments[i];
            if (ia != null && !ia.a_eject) {
                insertAmount += this.insertAmount(stack, ia, attached[i]);
            }
            ++i;
        }
        return insertAmount;
    }

    private int insertAmount(ye stack, ItemAttachment ia, InventoryRange range) {
        int filter = this.filterCount(ia, stack);
        if (filter == 0) {
            return 0;
        }
        int fit = InventoryUtils.getInsertableQuantity((InventoryRange)range, (ye)stack);
        if (fit == 0) {
            return 0;
        }
        if (ia.regulate && filter > 0) {
            fit = Math.min(fit, filter - this.countMatchingStacks(range, stack, true));
        }
        return fit > 0 ? fit : 0;
    }

    private int extractAmount(ye stack, ItemAttachment ia, InventoryRange range) {
        int qty;
        int filter = this.filterCount(ia, stack);
        if (filter == 0) {
            return ia.regulate ? stack.e() : 0;
        }
        int n = qty = filter < 0 ? stack.e() : filter;
        if (ia.regulate && filter > 0) {
            qty = Math.min(qty, this.countMatchingStacks(range, stack, false) - filter);
        }
        return qty > 0 ? qty : 0;
    }

    @Override
    public void handleDescriptionPacket(PacketCustom packet) {
        if (packet.getType() == 2) {
            this.movingItems.add(new MovingItem(packet));
        } else {
            super.handleDescriptionPacket(packet);
        }
    }

    @Override
    public int strongPowerLevel(int side) {
        ItemAttachment ia = (ItemAttachment)this.attachments[side ^ 1];
        if (ia != null && ia.a_powering) {
            return 15;
        }
        return 0;
    }

    public class ItemAttachment
    extends TileTranslocator.Attachment {
        boolean regulate;
        boolean a_powering;
        boolean signal;
        ye[] filters;

        public ItemAttachment(int side) {
            super(TileItemTranslocator.this, side);
            this.regulate = false;
            this.a_powering = false;
            this.signal = false;
            this.filters = new ye[9];
        }

        public void setPowering(boolean b) {
            if ((this.signal || !b) && b != this.a_powering) {
                this.a_powering = b;
                BlockCoord pos = new BlockCoord((asp)TileItemTranslocator.this);
                TileItemTranslocator.this.k.f(pos.x, pos.y, pos.z, aqz.aA.cF);
                pos.offset(this.side);
                TileItemTranslocator.this.k.f(pos.x, pos.y, pos.z, aqz.aA.cF);
                this.markUpdate();
            }
        }

        @Override
        public boolean activate(uf player, int subPart) {
            ye held = player.bn.h();
            if (held == null) {
                return super.activate(player, subPart);
            }
            if (held.b() == Translocator.itemDiamondNugget && !this.regulate) {
                this.regulate = true;
                if (!player.bG.d) {
                    --held.b;
                }
                this.markUpdate();
                return true;
            }
            if (held.b() == yc.q && !this.signal) {
                this.signal = true;
                if (!player.bG.d) {
                    --held.b;
                }
                this.markUpdate();
                return true;
            }
            return super.activate(player, subPart);
        }

        @Override
        public void stripModifiers() {
            super.stripModifiers();
            if (this.regulate) {
                this.regulate = false;
                TileItemTranslocator.this.dropItem(new ye(Translocator.itemDiamondNugget));
            }
            if (this.signal) {
                this.setPowering(false);
                this.signal = false;
                TileItemTranslocator.this.dropItem(new ye(yc.q));
            }
        }

        @Override
        public Collection<ye> getDrops() {
            Collection<ye> stuff = super.getDrops();
            if (this.regulate) {
                stuff.add(new ye(Translocator.itemDiamondNugget));
            }
            if (this.signal) {
                stuff.add(new ye(yc.q));
            }
            return stuff;
        }

        @Override
        public int getIconIndex() {
            int i = super.getIconIndex();
            if (this.regulate) {
                i |= 8;
            }
            if (this.signal) {
                i |= this.a_powering ? 32 : 16;
            }
            return i;
        }

        @Override
        public void openGui(uf player) {
            this.openItemGui(player, this.filters, this.regulate ? "translocator.regulate" : "translocator.filter");
        }

        private void openItemGui(uf player, ye[] filters, final String string) {
            ServerUtils.openSMPContainer((jv)((jv)player), (uy)new ContainerItemTranslocator(new InventorySimple(filters, this.filterStackLimit()){

                public void e() {
                    ItemAttachment.this.markUpdate();
                }
            }, player.bn), (IGuiPacketSender)new IGuiPacketSender(){

                public void sendPacket(jv player, int windowId) {
                    PacketCustom packet = new PacketCustom(TranslocatorSPH.channel, 4);
                    packet.writeByte(windowId);
                    packet.writeShort(ItemAttachment.this.filterStackLimit());
                    packet.writeString(string);
                    packet.sendToPlayer((uf)player);
                }
            });
        }

        private int filterStackLimit() {
            if (this.regulate) {
                return 65535;
            }
            if (this.fast) {
                return 64;
            }
            return 1;
        }

        @Override
        public void read(by tag) {
            super.read(tag);
            this.regulate = tag.n("regulate");
            this.signal = tag.n("signal");
            this.a_powering = tag.n("powering");
            InventoryUtils.readItemStacksFromTag((ye[])this.filters, (cg)tag.m("filters"));
        }

        @Override
        public by write(by tag) {
            tag.a("regulate", this.regulate);
            tag.a("signal", this.signal);
            tag.a("powering", this.a_powering);
            tag.a("filters", (cl)InventoryUtils.writeItemStacksToTag((ye[])this.filters, (int)65536));
            return super.write(tag);
        }

        @Override
        public void read(PacketCustom packet, boolean described) {
            super.read(packet, described);
            this.regulate = packet.readBoolean();
            this.signal = packet.readBoolean();
            this.a_powering = packet.readBoolean();
        }

        @Override
        public void write(PacketCustom packet) {
            super.write(packet);
            packet.writeBoolean(this.regulate);
            packet.writeBoolean(this.signal);
            packet.writeBoolean(this.a_powering);
        }
    }

    public class MovingItem {
        public int src;
        public int dst;
        public ye stack;
        public double a_progress;
        public double b_progress;

        public MovingItem(PacketCustom packet) {
            int b = packet.readUByte();
            this.src = b >> 4;
            this.dst = b & 0xF;
            this.stack = packet.readItemStack();
        }

        public boolean update() {
            if (this.a_progress >= 1.0) {
                return true;
            }
            this.b_progress = this.a_progress;
            this.a_progress = MathHelper.approachLinear((double)this.a_progress, (double)1.0, (double)0.2);
            return false;
        }
    }
}

