/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.BuildCraftCore;
import buildcraft.core.IInventoryRenderer;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderingEntityBlocks
implements ISimpleBlockRenderingHandler {
    private static final ResourceLocation BLOCK_TEXTURE = TextureMap.field_110575_b;
    public static HashMap<EntityRenderIndex, IInventoryRenderer> blockByEntityRenders = new HashMap();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (block.func_71857_b() == BuildCraftCore.blockByEntityModel) {
            EntityRenderIndex index = new EntityRenderIndex(block, metadata);
            if (blockByEntityRenders.containsKey(index)) {
                blockByEntityRenders.get(index).inventoryRender(-0.5, -0.5, -0.5, 0.0f, 0.0f);
            }
        } else if (block.func_71857_b() == BuildCraftCore.legacyPipeModel) {
            Tessellator tessellator = Tessellator.field_78398_a;
            block.func_71905_a(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
            renderer.func_83018_a(block);
            block.func_71919_f();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderer.func_78613_a(block, 0.0, 0.0, 0.0, block.func_71858_a(0, metadata));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderer.func_78617_b(block, 0.0, 0.0, 0.0, block.func_71858_a(1, metadata));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderer.func_78611_c(block, 0.0, 0.0, 0.0, block.func_71858_a(2, metadata));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderer.func_78622_d(block, 0.0, 0.0, 0.0, block.func_71858_a(3, metadata));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderer.func_78573_e(block, 0.0, 0.0, 0.0, block.func_71858_a(4, metadata));
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderer.func_78605_f(block, 0.0, 0.0, 0.0, block.func_71858_a(5, metadata));
            tessellator.func_78381_a();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            block.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (block.func_71857_b() != BuildCraftCore.blockByEntityModel && block.func_71857_b() == BuildCraftCore.legacyPipeModel) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(BLOCK_TEXTURE);
            this.legacyPipeRender(renderer, world, x, y, z, block, modelId);
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return BuildCraftCore.blockByEntityModel;
    }

    private void legacyPipeRender(RenderBlocks renderblocks, IBlockAccess iblockaccess, int i, int j, int k, Block block, int l) {
        float minSize = 0.25f;
        float maxSize = 0.75f;
        block.func_71905_a(minSize, minSize, minSize, maxSize, maxSize, maxSize);
        renderblocks.func_83018_a(block);
        renderblocks.func_78570_q(block, i, j, k);
        if (Utils.checkLegacyPipesConnections(iblockaccess, i, j, k, i - 1, j, k)) {
            block.func_71905_a(0.0f, minSize, minSize, minSize, maxSize, maxSize);
            renderblocks.func_83018_a(block);
            renderblocks.func_78570_q(block, i, j, k);
        }
        if (Utils.checkLegacyPipesConnections(iblockaccess, i, j, k, i + 1, j, k)) {
            block.func_71905_a(maxSize, minSize, minSize, 1.0f, maxSize, maxSize);
            renderblocks.func_83018_a(block);
            renderblocks.func_78570_q(block, i, j, k);
        }
        if (Utils.checkLegacyPipesConnections(iblockaccess, i, j, k, i, j - 1, k)) {
            block.func_71905_a(minSize, 0.0f, minSize, maxSize, minSize, maxSize);
            renderblocks.func_83018_a(block);
            renderblocks.func_78570_q(block, i, j, k);
        }
        if (Utils.checkLegacyPipesConnections(iblockaccess, i, j, k, i, j + 1, k)) {
            block.func_71905_a(minSize, maxSize, minSize, maxSize, 1.0f, maxSize);
            renderblocks.func_83018_a(block);
            renderblocks.func_78570_q(block, i, j, k);
        }
        if (Utils.checkLegacyPipesConnections(iblockaccess, i, j, k, i, j, k - 1)) {
            block.func_71905_a(minSize, minSize, 0.0f, maxSize, maxSize, minSize);
            renderblocks.func_83018_a(block);
            renderblocks.func_78570_q(block, i, j, k);
        }
        if (Utils.checkLegacyPipesConnections(iblockaccess, i, j, k, i, j, k + 1)) {
            block.func_71905_a(minSize, minSize, maxSize, maxSize, maxSize, 1.0f);
            renderblocks.func_83018_a(block);
            renderblocks.func_78570_q(block, i, j, k);
        }
        block.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public static class EntityRenderIndex {
        Block block;
        int damage;

        public EntityRenderIndex(Block block, int damage) {
            this.block = block;
            this.damage = damage;
        }

        public int hashCode() {
            return this.block.hashCode() + this.damage;
        }

        public boolean equals(Object o) {
            if (!(o instanceof EntityRenderIndex)) {
                return false;
            }
            EntityRenderIndex i = (EntityRenderIndex)o;
            return i.block == this.block && i.damage == this.damage;
        }
    }
}

