/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui.tooltips;

import buildcraft.core.gui.tooltips.ToolTipLine;
import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.List;

public class ToolTip
extends ForwardingList<ToolTipLine> {
    private final List<ToolTipLine> delegate = new ArrayList<ToolTipLine>();
    private final long delay;
    private long mouseOverStart;

    public ToolTip() {
        this.delay = 0L;
    }

    public ToolTip(int delay) {
        this.delay = delay;
    }

    protected final List<ToolTipLine> delegate() {
        return this.delegate;
    }

    public void onTick(boolean mouseOver) {
        if (this.delay == 0L) {
            return;
        }
        if (mouseOver) {
            if (this.mouseOverStart == 0L) {
                this.mouseOverStart = System.currentTimeMillis();
            }
        } else {
            this.mouseOverStart = 0L;
        }
    }

    public boolean isReady() {
        if (this.delay == 0L) {
            return true;
        }
        if (this.mouseOverStart == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.mouseOverStart >= this.delay;
    }

    public void refresh() {
    }
}

