/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.util;

import com.google.common.collect.ImmutableSortedSet;
import dan200.computer.api.IMount;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import java.util.SortedSet;

public class ResourceMount
implements IMount {
    private static final String RESOURCE_PATH = "/openperipheral/lua/";
    private final SortedSet<String> files;

    public ResourceMount() {
        ImmutableSortedSet.Builder files = ImmutableSortedSet.naturalOrder();
        InputStream fileList = this.getClass().getResourceAsStream("/openperipheral/lua/files.lst");
        if (fileList != null) {
            Scanner sc = new Scanner(fileList);
            while (sc.hasNextLine()) {
                String fileName = sc.nextLine();
                files.add((Object)fileName);
            }
            sc.close();
        }
        this.files = files.build();
    }

    public boolean exists(String path) throws IOException {
        return path.isEmpty() || this.files.contains(path);
    }

    public boolean isDirectory(String path) throws IOException {
        return path.isEmpty();
    }

    public void list(String path, List<String> contents) throws IOException {
        contents.addAll(this.files);
    }

    public long getSize(String path) throws IOException {
        return 0L;
    }

    public InputStream openForRead(String path) throws IOException {
        if (!this.files.contains(path)) {
            throw new IOException();
        }
        return this.getClass().getResourceAsStream(RESOURCE_PATH + path);
    }
}

