/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class ReflectionHelper {
    public Object nullValue(Class<?> cls) {
        return new NullMarker(cls);
    }

    public static Object getProperty(Class<?> klazz, Object instance, String ... fields) {
        Field field = ReflectionHelper.getField(klazz == null ? instance.getClass() : klazz, fields);
        Preconditions.checkNotNull((Object)field, (String)"Fields %s not found", (Object[])new Object[]{Arrays.toString(fields)});
        try {
            return field.get(instance);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Object getProperty(String className, Object instance, String ... fields) {
        return ReflectionHelper.getProperty(ReflectionHelper.getClass(className), instance, fields);
    }

    public static <T> T callStatic(Class<?> klazz, String methodName, Object ... args) {
        return ReflectionHelper.call(klazz, null, (String[])ArrayUtils.toArray((Object[])new String[]{methodName}), args);
    }

    public static <T> T call(Object instance, String methodName, Object ... args) {
        return ReflectionHelper.call(instance.getClass(), instance, (String[])ArrayUtils.toArray((Object[])new String[]{methodName}), args);
    }

    private static <T> T call(Class<?> klazz, Object instance, String[] methodNames, Object ... args) {
        Method m = ReflectionHelper.getMethod(klazz, methodNames, args);
        Preconditions.checkNotNull((Object)m, (String)"Method %s not found", (Object[])new Object[]{Arrays.toString(methodNames)});
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (!(arg instanceof NullMarker)) continue;
            args[i] = null;
        }
        try {
            return (T)m.invoke(instance, args.length);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Method getMethod(Class<?> klazz, String[] methodNames, Object ... args) {
        if (klazz == null) {
            return null;
        }
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            argTypes[i] = arg instanceof NullMarker ? ((NullMarker)arg).cls : arg.getClass();
        }
        for (String name : methodNames) {
            Method result = ReflectionHelper.getDeclaredMethod(klazz, name, argTypes);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?>[] argsTypes) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod(name, argsTypes);
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static List<Method> getAllMethods(Class<?> clazz) {
        ArrayList methods = Lists.newArrayList();
        while (clazz != null) {
            for (Method m : clazz.getDeclaredMethods()) {
                methods.add(m);
            }
            clazz = clazz.getSuperclass();
        }
        return methods;
    }

    public static Field getField(Class<?> klazz, String ... fields) {
        for (String field : fields) {
            for (Class<?> current = klazz; current != null; current = current.getSuperclass()) {
                try {
                    Field f = current.getDeclaredField(field);
                    f.setAccessible(true);
                    return f;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }
        return null;
    }

    public static Class<?> getClass(String className) {
        if (Strings.isNullOrEmpty((String)className)) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class NullMarker {
        public final Class<?> cls;

        private NullMarker(Class<?> cls) {
            this.cls = cls;
        }
    }
}

