/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.util;

import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PeripheralUtils {
    private static Map<String, Class<? extends TileEntity>> teNameToClass;
    private static Map<Class<? extends TileEntity>, String> teClassToName;

    public static Map<Class<? extends TileEntity>, String> getClassToNameMap() {
        if (teClassToName == null) {
            teClassToName = (Map)ReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"classToNameMap", "field_70323_b"});
        }
        return teClassToName;
    }

    public static Map<String, Class<? extends TileEntity>> getNameToClassMap() {
        if (teNameToClass == null) {
            teNameToClass = (Map)ReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"nameToClassMap", "field_70326_a"});
        }
        return teNameToClass;
    }

    public static String getNameForTarget(Object target) {
        String name = "";
        if (target instanceof IInventory) {
            name = ((IInventory)target).func_70303_b();
        } else if (target instanceof TileEntity) {
            TileEntity te = (TileEntity)target;
            name = PeripheralUtils.getClassToNameMap().get(te.getClass());
            if (Strings.isNullOrEmpty((String)name)) {
                Block block = te.func_70311_o();
                int dmg = te.func_70322_n();
                ItemStack is = new ItemStack(block, 1, dmg);
                try {
                    name = is.func_82833_r();
                }
                catch (Exception e) {
                    try {
                        name = is.func_77977_a();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if (Strings.isNullOrEmpty((String)name)) {
                    name = te.getClass().getSimpleName();
                }
            }
        }
        return Strings.isNullOrEmpty((String)name) ? "peripheral" : name.replaceAll("[^a-zA-Z0-9]", "_").toLowerCase();
    }
}

