/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.util;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import openperipheral.IntegrationModuleRegistry;

public class InventoryDescriptionUtils {
    public static final String FACTORIZATION_BARREL_CLASS = "factorization.common.TileEntityBarrel";

    public static String getNameForItemStack(ItemStack is) {
        String name = "Unknown";
        try {
            name = is.func_82833_r();
        }
        catch (Exception e) {
            try {
                name = is.func_77977_a();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return name;
    }

    public static String getRawNameForStack(ItemStack is) {
        String rawName = "unknown";
        try {
            rawName = is.func_77977_a().toLowerCase();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String packageName;
            String[] packageLevels;
            if (rawName.length() - rawName.replaceAll("\\.", "").length() == 0 && !rawName.startsWith((packageLevels = (packageName = is.func_77973_b().getClass().getName().toLowerCase()).split("\\."))[0]) && packageLevels.length > 1) {
                rawName = packageLevels[0] + "." + rawName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rawName.trim();
    }

    public static Map<Integer, Map<String, Object>> invToMap(IInventory inventory) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            map.put(i + 1, InventoryDescriptionUtils.itemstackToMap(inventory.func_70301_a(i)));
        }
        if (inventory.getClass().getName() == FACTORIZATION_BARREL_CLASS) {
            try {
                TileEntity barrel = (TileEntity)inventory;
                NBTTagCompound compound = new NBTTagCompound();
                barrel.func_70310_b(compound);
                Map firstStack = (Map)map.get(1);
                firstStack.put("size", compound.func_74762_e("item_count"));
                firstStack.put("maxStack", compound.func_74762_e("upgrade") == 1 ? 65536 : 4096);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    public static Map<String, Object> itemstackToMap(ItemStack itemstack) {
        HashMap map = Maps.newHashMap();
        if (itemstack == null) {
            map.put("id", 0);
            map.put("name", "empty");
            map.put("rawName", "empty");
            map.put("qty", 0);
            map.put("dmg", 0);
            map.put("maxSize", 64);
        } else {
            map.put("id", itemstack.field_77993_c);
            map.put("name", InventoryDescriptionUtils.getNameForItemStack(itemstack));
            map.put("rawName", InventoryDescriptionUtils.getRawNameForStack(itemstack));
            map.put("qty", itemstack.field_77994_a);
            map.put("dmg", itemstack.func_77960_j());
            map.put("maxSize", itemstack.func_77976_d());
            IntegrationModuleRegistry.appendItemInfo(map, itemstack);
        }
        return map;
    }
}

