/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import dan200.computer.api.IComputerAccess;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openmods.utils.InventoryUtils;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;

public class AdapterInventory
implements IPeripheralAdapter {
    @Override
    public Class<?> getTargetClass() {
        return IInventory.class;
    }

    @LuaMethod(returnType=LuaType.STRING, description="Get the name of this inventory")
    public String getInventoryName(IComputerAccess computer, IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        if (inventory == null) {
            return null;
        }
        return inventory.func_70303_b();
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Get the size of this inventory")
    public int getInventorySize(IComputerAccess computer, IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        if (inventory == null) {
            return 0;
        }
        return inventory.func_70302_i_();
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Pull an item from a slot in another inventory into a specific slot in this one. Returns the amount of items moved", args={@Arg(type=LuaType.STRING, name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)"), @Arg(type=LuaType.NUMBER, name="slot", description="The slot in the OTHER inventory that you're pulling from"), @Arg(type=LuaType.NUMBER, name="maxAmount", description="The maximum amount of items you want to pull"), @Arg(type=LuaType.NUMBER, name="intoSlot", description="The slot in the current inventory that you want to pull into")})
    public int pullItemIntoSlot(IComputerAccess computer, IInventory target, ForgeDirection direction, int slot, int maxAmount, int intoSlot) throws Exception {
        int merged = 0;
        TileEntity te = (TileEntity)target;
        IInventory otherInventory = InventoryUtils.getInventory((World)te.field_70331_k, (int)te.field_70329_l, (int)te.field_70330_m, (int)te.field_70327_n, (ForgeDirection)direction);
        if (otherInventory == null || otherInventory == target) {
            return 0;
        }
        merged = InventoryUtils.moveItemInto((IInventory)otherInventory, (int)(slot - 1), (Object)InventoryUtils.getInventory((IInventory)target), (int)(intoSlot - 1), (int)maxAmount, (ForgeDirection)direction.getOpposite(), (boolean)true);
        return merged;
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Push an item from the current inventory into a specific slot in the other one. Returns the amount of items moved", args={@Arg(type=LuaType.STRING, name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)"), @Arg(type=LuaType.NUMBER, name="slot", description="The slot in the current inventory that you're pushing from"), @Arg(type=LuaType.NUMBER, name="maxAmount", description="The maximum amount of items you want to push"), @Arg(type=LuaType.NUMBER, name="intoSlot", description="The slot in the other inventory that you want to push into")})
    public int pushItemIntoSlot(IComputerAccess computer, IInventory target, ForgeDirection direction, int slot, int maxAmount, int intoSlot) throws Exception {
        int merged = 0;
        TileEntity te = (TileEntity)target;
        IInventory otherInventory = InventoryUtils.getInventory((World)te.field_70331_k, (int)te.field_70329_l, (int)te.field_70330_m, (int)te.field_70327_n, (ForgeDirection)direction);
        if (otherInventory == null || otherInventory == target) {
            return 0;
        }
        merged = InventoryUtils.moveItemInto((IInventory)InventoryUtils.getInventory((IInventory)target), (int)(slot - 1), (Object)otherInventory, (int)(intoSlot - 1), (int)maxAmount, (ForgeDirection)direction.getOpposite(), (boolean)true);
        return merged;
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Push an item from the current inventory into any slot on the other one. Returns the amount of items moved", args={@Arg(type=LuaType.STRING, name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)"), @Arg(type=LuaType.NUMBER, name="slot", description="The slot in the current inventory that you're pushing from"), @Arg(type=LuaType.NUMBER, name="maxAmount", description="The maximum amount of items you want to push")})
    public int pushItem(IComputerAccess computer, IInventory target, ForgeDirection direction, int slot, int maxAmount) throws Exception {
        int merged = 0;
        TileEntity te = (TileEntity)target;
        IInventory otherInventory = InventoryUtils.getInventory((World)te.field_70331_k, (int)te.field_70329_l, (int)te.field_70330_m, (int)te.field_70327_n, (ForgeDirection)direction);
        if (otherInventory == null || otherInventory == target) {
            return 0;
        }
        merged = InventoryUtils.moveItemInto((IInventory)InventoryUtils.getInventory((IInventory)target), (int)(slot - 1), (Object)otherInventory, (int)-1, (int)maxAmount, (ForgeDirection)direction.getOpposite(), (boolean)true);
        return merged;
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Pull an item from the target inventory into any slot in the current one. Returns the amount of items moved", args={@Arg(type=LuaType.STRING, name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)"), @Arg(type=LuaType.NUMBER, name="slot", description="The slot in the other inventory that you're pulling from"), @Arg(type=LuaType.NUMBER, name="maxAmount", description="The maximum amount of items you want to pull")})
    public int pullItem(IComputerAccess computer, IInventory target, ForgeDirection direction, int slot, int maxAmount) throws Exception {
        int merged = 0;
        TileEntity te = (TileEntity)target;
        IInventory otherInventory = InventoryUtils.getInventory((World)te.field_70331_k, (int)te.field_70329_l, (int)te.field_70330_m, (int)te.field_70327_n, (ForgeDirection)direction);
        if (otherInventory == null || otherInventory == target) {
            return 0;
        }
        merged = InventoryUtils.moveItemInto((IInventory)otherInventory, (int)(slot - 1), (Object)InventoryUtils.getInventory((IInventory)target), (int)-1, (int)maxAmount, (ForgeDirection)direction.getOpposite(), (boolean)true);
        return merged;
    }

    @LuaMethod(returnType=LuaType.VOID, description="Condense and tidy the stacks in an inventory")
    public void condenseItems(IComputerAccess computer, IInventory target) throws Exception {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        if (inventory == null && target != null) {
            System.out.println("OpenPeripheral Warning: (condenseItems) getInventory for the same inventory failed hard. That's a bug!!!");
            inventory = target;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack sta = inventory.func_70301_a(i);
            if (sta != null) {
                stacks.add(sta.func_77946_l());
            }
            inventory.func_70299_a(i, null);
        }
        for (ItemStack stack : stacks) {
            InventoryUtils.insertItemIntoInventory((IInventory)inventory, (ItemStack)stack, (ForgeDirection)ForgeDirection.UNKNOWN, (int)-1);
        }
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="Swap two slots in the inventory", args={@Arg(type=LuaType.NUMBER, name="from", description="The first slot"), @Arg(type=LuaType.NUMBER, name="to", description="The other slot")})
    public boolean swapStacks(IComputerAccess computer, IInventory target, int from, int to) throws Exception {
        --from;
        --to;
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        if (inventory == null && target != null) {
            System.out.println("OpenPeripheral Warning: (swapStacks) getInventory for the same inventory failed hard. That's a bug!!!");
            inventory = target;
        }
        if (from >= 0 && from < inventory.func_70302_i_() && to >= 0 && to < inventory.func_70302_i_()) {
            ItemStack stack1 = inventory.func_70301_a(from);
            ItemStack stack2 = inventory.func_70301_a(to);
            if (stack1 != null) {
                stack1 = stack1.func_77946_l();
            }
            if (stack2 != null) {
                stack2 = stack2.func_77946_l();
            }
            inventory.func_70299_a(from, stack2);
            inventory.func_70299_a(to, stack1);
            return true;
        }
        return false;
    }

    @LuaMethod(returnType=LuaType.TABLE, description="Get details of an item in a particular slot", args={@Arg(type=LuaType.NUMBER, name="slotNumber", description="The slot number, from 1 to the max amount of slots")})
    public ItemStack getStackInSlot(IComputerAccess computer, IInventory target, int slot) throws Exception {
        IInventory invent = InventoryUtils.getInventory((IInventory)target);
        if (--slot < 0 || slot >= invent.func_70302_i_()) {
            throw new Exception("Invalid slot number");
        }
        return invent.func_70301_a(slot);
    }

    @LuaMethod(returnType=LuaType.TABLE, description="Get a table with all the items of the chest")
    public ItemStack[] getAllStacks(IComputerAccess computer, IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        ItemStack[] allStacks = new ItemStack[inventory.func_70302_i_()];
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            allStacks[i] = inventory.func_70301_a(i);
        }
        return allStacks;
    }

    @LuaMethod(returnType=LuaType.VOID, description="Destroy a stack", args={@Arg(type=LuaType.NUMBER, name="slotNumber", description="The slot number, from 1 to the max amount of slots")})
    public void destroyStack(IComputerAccess computer, IInventory target, int slot) throws Exception {
        IInventory invent = InventoryUtils.getInventory((IInventory)target);
        if (--slot < 0 || slot >= invent.func_70302_i_()) {
            throw new Exception("Invalid slot number");
        }
        invent.func_70299_a(slot, null);
    }
}

