/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import dan200.computer.api.IComputerAccess;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityBeacon;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;

public class AdapterBeacon
implements IPeripheralAdapter {
    private static final String NONE = "None";

    @Override
    public Class<?> getTargetClass() {
        return TileEntityBeacon.class;
    }

    @LuaMethod(returnType=LuaType.STRING, description="Get the primary effect of the beacon")
    public String getPrimaryEffect(IComputerAccess computer, TileEntityBeacon beacon) {
        Integer effectId = beacon.func_82126_i();
        return AdapterBeacon.getEffectName(effectId);
    }

    @LuaMethod(returnType=LuaType.STRING, description="Get the secondary effect of the beacon")
    public String getSecondaryEffect(IComputerAccess computer, TileEntityBeacon beacon) {
        Integer effectId = beacon.func_82132_j();
        return AdapterBeacon.getEffectName(effectId);
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="Get the height of the beacon's pyramid")
    public int getLevels(IComputerAccess computer, TileEntityBeacon beacon) {
        return beacon.func_82130_k();
    }

    private static String getEffectName(int effectId) {
        if (effectId != 0) {
            PotionEffect effect = new PotionEffect(effectId, 180, 0, true);
            return effect.func_76453_d();
        }
        return NONE;
    }
}

