/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.sgcraft;

import dan200.computer.api.IComputerAccess;
import java.lang.reflect.Field;
import net.minecraft.tileentity.TileEntity;
import openperipheral.api.Arg;
import openperipheral.api.IPeripheralAdapter;
import openperipheral.api.LuaMethod;
import openperipheral.api.LuaType;
import openperipheral.util.ReflectionHelper;

public class AdapterStargate
implements IPeripheralAdapter {
    private final Class<?> STARGATE_TILE_CLASS = ReflectionHelper.getClass("gcewing.sg.SGBaseTE");
    private final Class<?> SG_ADDRESSING_CLASS = ReflectionHelper.getClass("gcewing.sg.SGAddressing");

    @Override
    public Class<?> getTargetClass() {
        return this.STARGATE_TILE_CLASS;
    }

    @LuaMethod(returnType=LuaType.VOID, description="connects the stargate to the supplied address", args={@Arg(type=LuaType.STRING, description="the address of the gate to connect to")})
    public void connect(IComputerAccess computer, TileEntity tile, String targetAddress) throws Exception {
        this.checkGateComplete(tile);
        targetAddress = targetAddress.toUpperCase();
        this.validateAddress(tile, targetAddress);
        String homeAddress = (String)ReflectionHelper.call(tile, "findHomeAddress", new Object[0]);
        TileEntity targetStargate = (TileEntity)ReflectionHelper.call(this.SG_ADDRESSING_CLASS, "findAddressedStargate", targetAddress);
        boolean targetBusy = (Boolean)ReflectionHelper.call(targetStargate, "isConnected", new Object[0]);
        if (targetBusy) {
            throw new Exception("Stargate at address " + targetAddress + " is busy");
        }
        int requiredFuel = (Integer)ReflectionHelper.getProperty(this.getTargetClass(), (Object)tile, "fuelToOpen");
        boolean fuelReloaded = (Boolean)ReflectionHelper.call(tile, "reloadFuel", requiredFuel);
        if (!fuelReloaded) {
            throw new Exception("Stargate has insufficient fuel");
        }
        ReflectionHelper.call(tile, "startDiallingStargate", targetAddress, targetStargate, true);
        ReflectionHelper.call(targetStargate, "startDiallingStargate", homeAddress, tile, false);
    }

    @LuaMethod(returnType=LuaType.STRING, description="gets state of the stargate", onTick=false)
    public String getState(IComputerAccess computer, TileEntity tile) throws Exception {
        this.checkGateComplete(tile);
        Field field = ReflectionHelper.getField(this.getTargetClass(), "state");
        return field.get(tile).toString();
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="gets the number of locked chevrons", onTick=false)
    public int getLockedChevronCount(IComputerAccess computer, TileEntity tile) throws Exception {
        this.checkGateComplete(tile);
        Field field = ReflectionHelper.getField(this.getTargetClass(), "numEngagedChevrons");
        return field.getInt(tile);
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="gets the amount of buffered fuel", onTick=false)
    public int getFuelLevel(IComputerAccess computer, TileEntity tile) throws Exception {
        this.checkGateComplete(tile);
        Field field = ReflectionHelper.getField(this.getTargetClass(), "fuelBuffer");
        return field.getInt(tile);
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="gets maximum amount of buffered fuel", onTick=false)
    public int getMaxFuelLevel(IComputerAccess computer, TileEntity tile) throws Exception {
        this.checkGateComplete(tile);
        Field field = ReflectionHelper.getField(this.getTargetClass(), "maxFuelBuffer");
        return field.getInt(tile);
    }

    @LuaMethod(returnType=LuaType.NUMBER, description="is the stargate connected to a controller", onTick=false)
    public boolean isDHDConnected(IComputerAccess computer, TileEntity tile) throws Exception {
        this.checkGateComplete(tile);
        Field field = ReflectionHelper.getField(this.getTargetClass(), "isLinkedToController");
        return field.getBoolean(tile);
    }

    @LuaMethod(returnType=LuaType.VOID, description="disconnects the stargate")
    public void disconnect(IComputerAccess computer, TileEntity tile) throws Exception {
        this.checkGateComplete(tile);
        Object connectedLocation = ReflectionHelper.getProperty(this.getTargetClass(), (Object)tile, "connectedLocation");
        TileEntity connectedGate = (TileEntity)ReflectionHelper.call(this.getTargetClass(), null, new String[]{"at"}, new Object[]{connectedLocation});
        if (connectedGate != null) {
            ReflectionHelper.call(connectedGate, "clearConnection", new Object[0]);
        }
        ReflectionHelper.call(tile, "clearConnection", new Object[0]);
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="whether or not the supplied address is a valid address", args={@Arg(type=LuaType.STRING, description="the address of the gate to validate")}, onTick=false)
    public boolean isValidAddress(IComputerAccess computer, TileEntity tile, String address) {
        try {
            this.validateAddress(tile, address.toUpperCase());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="whether or not the stargate currently has a connection", onTick=false)
    public boolean isConnected(IComputerAccess computer, TileEntity tile) throws Exception {
        this.checkGateComplete(tile);
        return (Boolean)ReflectionHelper.call(tile, "isConnected", new Object[0]);
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="whether or not the stargate created the connection", onTick=false)
    public boolean isInitiator(IComputerAccess computer, TileEntity tile) throws Exception {
        this.checkGateComplete(tile);
        return (Boolean)ReflectionHelper.getProperty(this.getTargetClass(), (Object)tile, "isInitiator");
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="whether or not the connection is travelable from this side", onTick=false)
    public boolean canTravelFromThisEnd(IComputerAccess computer, TileEntity tile) throws Exception {
        this.checkGateComplete(tile);
        return (Boolean)ReflectionHelper.call(tile, "canTravelFromThisEnd", new Object[0]);
    }

    @LuaMethod(returnType=LuaType.STRING, description="the address of the stargate the connection is linked", onTick=false)
    public String getDialledAddress(IComputerAccess computer, TileEntity tile) throws Exception {
        this.checkGateComplete(tile);
        return (String)ReflectionHelper.getProperty(this.getTargetClass(), (Object)tile, "dialledAddress");
    }

    @LuaMethod(returnType=LuaType.BOOLEAN, description="whether or not the Stargate is completed", onTick=false)
    public boolean isCompleteGate(IComputerAccess computer, TileEntity tile) {
        try {
            this.checkGateComplete(tile);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void checkGateComplete(TileEntity tile) throws Exception {
        boolean ringComplete = (Boolean)ReflectionHelper.getProperty(this.getTargetClass(), (Object)tile, "isMerged");
        if (!ringComplete) {
            throw new Exception("Stargate damaged or incomplete");
        }
    }

    private void validateAddress(TileEntity tile, String address) throws Exception {
        if (address.length() != 7) {
            throw new Exception("Stargate addresses must be 7 letters");
        }
        TileEntity targetStargate = (TileEntity)ReflectionHelper.call(this.SG_ADDRESSING_CLASS, null, new String[]{"findAddressedStargate"}, new Object[]{address});
        if (targetStargate == null) {
            throw new Exception("No Stargate at address " + address);
        }
        if (targetStargate == tile) {
            throw new Exception("Stargate cannot connect to itself");
        }
    }
}

