/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.railcraft;

import java.util.Map;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IEnergyTransfer;
import mods.railcraft.api.carts.IExplosiveCart;
import mods.railcraft.api.carts.ILinkableCart;
import mods.railcraft.api.carts.ILiquidTransfer;
import mods.railcraft.api.carts.IPaintedCart;
import mods.railcraft.api.carts.IRefuelableCart;
import mods.railcraft.api.carts.IRoutableCart;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import openperipheral.adapter.AdapterManager;
import openperipheral.api.IIntegrationModule;
import openperipheral.integration.railcraft.AdapterTileSteamTurbine;

public class ModuleRailcraft
implements IIntegrationModule {
    @Override
    public String getModId() {
        return "Railcraft";
    }

    @Override
    public void init() {
        AdapterManager.addPeripheralAdapter(new AdapterTileSteamTurbine());
    }

    @Override
    public void appendEntityInfo(Map<String, Object> map, Entity entity, Vec3 relativePos) {
        IEnergyTransfer cart;
        if (entity instanceof IEnergyTransfer) {
            cart = (IEnergyTransfer)entity;
            map.put("maxPower", cart.getCapacity());
            map.put("currentPower", cart.getEnergy());
            map.put("powerTier", cart.getTier());
            map.put("transferRate", cart.getTransferLimit());
        }
        if (entity instanceof IExplosiveCart) {
            cart = (IExplosiveCart)entity;
            map.put("primed", cart.isPrimed());
            map.put("fuse", cart.getFuse());
        }
        if (entity instanceof ILinkableCart) {
            cart = (ILinkableCart)entity;
            EntityMinecart minecart = (EntityMinecart)entity;
            boolean linkable = cart.isLinkable();
            map.put("linkable", linkable);
            if (linkable) {
                int cartCount = CartTools.linkageManager.countCartsInTrain(minecart);
                map.put("cartsInTrain", cartCount);
            }
            boolean hasOwner = CartTools.doesCartHaveOwner((EntityMinecart)minecart);
            map.put("hasOwner", hasOwner);
            if (hasOwner) {
                map.put("owner", CartTools.getCartOwner((EntityMinecart)minecart));
            }
        }
        if (entity instanceof ILiquidTransfer) {
            cart = (ILiquidTransfer)entity;
            map.put("isFilling", cart.isFilling());
        }
        if (entity instanceof IPaintedCart) {
            cart = (IPaintedCart)entity;
            map.put("primaryColor", cart.getPrimaryColor());
            map.put("secondaryColor", cart.getSecondaryColor());
        }
        if (entity instanceof IRefuelableCart) {
            cart = (IRefuelableCart)entity;
            map.put("needsRefuel", cart.needsRefuel());
        }
        if (entity instanceof IRoutableCart) {
            cart = (IRoutableCart)entity;
            map.put("destination", cart.getDestination());
        }
    }

    @Override
    public void appendItemInfo(Map<String, Object> map, ItemStack itemstack) {
    }
}

